/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.widget;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.baijiayun.bjyutils.StringUtils;
import com.baijiayun.bjyutils.drawable.DrawableBuilder;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.glide.Glide;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.bean.SignModel;
import com.baijiayun.videoplayer.ui.listener.CallbackManager;
import com.baijiayun.videoplayer.ui.viewmodel.VideoPlayViewModel;
import org.jetbrains.annotations.Nullable;

public class SignDialogFragment
extends BaseDialogFragment {
    private ImageView logoIv;
    private TextView titleTv;
    private TextView contentTv;
    private TextView btnText;
    private VideoPlayViewModel videoPlayViewModel;

    public void onViewCreated(@NonNull View view, @androidx.annotation.Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.hideTitleBar();
        this.videoPlayViewModel = (VideoPlayViewModel)new ViewModelProvider((ViewModelStoreOwner)this.getActivity()).get(VideoPlayViewModel.class);
        this.logoIv = (ImageView)view.findViewById(R.id.logo_iv);
        this.titleTv = (TextView)view.findViewById(R.id.title_tv);
        this.contentTv = (TextView)view.findViewById(R.id.content_tv);
        this.btnText = (TextView)view.findViewById(R.id.btn_tv);
        this.btnText.setBackground(new DrawableBuilder().solidColor(-14786817).cornerRadius(UtilsKt.getDp((int)4)).build());
        this.btnText.setOnClickListener(v -> {
            if (this.videoPlayViewModel.getShowSignDialog().getValue() != null) {
                this.videoPlayViewModel.onSign((SignModel)this.videoPlayViewModel.getShowSignDialog().getValue());
                if (CallbackManager.getInstance().getSignModelConsumer() != null) {
                    CallbackManager.getInstance().getSignModelConsumer().accept((Object)((SignModel)this.videoPlayViewModel.getShowSignDialog().getValue()));
                }
            }
            this.dismissAllowingStateLoss();
        });
        this.videoPlayViewModel.getShowSignDialog().observe((LifecycleOwner)this, signModel -> {
            if (signModel != null) {
                this.setSignModel((SignModel)signModel);
            }
        });
    }

    public void onStart() {
        super.onStart();
        this.getDialog().getWindow().setBackgroundDrawable(new DrawableBuilder().solidColor(-1).cornerRadius(UtilsKt.getDp((int)8)).build());
    }

    protected boolean isCanceled() {
        return false;
    }

    protected boolean isCanceledOnTouchOutside() {
        return false;
    }

    protected void setWindowParams(WindowManager.LayoutParams windowParams) {
        windowParams.dimAmount = 0.5f;
        windowParams.flags |= 2;
        windowParams.width = UtilsKt.getDp((int)320);
        windowParams.height = -2;
        windowParams.gravity = 17;
    }

    private void setSignModel(@androidx.annotation.Nullable SignModel signModel) {
        if (signModel == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)signModel.logo) && signModel.logo.startsWith("http")) {
            Glide.with((Context)this.getContext()).load(signModel.logo).into(this.logoIv);
        } else {
            this.logoIv.setImageResource(R.drawable.bjy_ic_sign_in);
        }
        if (!TextUtils.isEmpty((CharSequence)signModel.title)) {
            this.titleTv.setText((CharSequence)StringUtils.getLimitedLengthString((String)signModel.title, (int)16));
        } else {
            this.titleTv.setText((CharSequence)this.getContext().getResources().getString(R.string.bjy_pb_sign_in_title));
        }
        if (!TextUtils.isEmpty((CharSequence)signModel.content)) {
            this.contentTv.setText((CharSequence)StringUtils.getLimitedLengthString((String)signModel.content, (int)48));
        } else {
            this.contentTv.setText((CharSequence)this.getContext().getResources().getString(R.string.bjy_pb_sign_in_content));
        }
        if (!TextUtils.isEmpty((CharSequence)signModel.btnText)) {
            this.btnText.setText((CharSequence)StringUtils.getLimitedLengthString((String)signModel.btnText, (int)4));
        } else {
            this.btnText.setText((CharSequence)this.getContext().getResources().getString(R.string.bjy_pb_sign_in));
        }
    }

    protected int getLayoutId() {
        return R.layout.bjy_pb_layout_sign_in;
    }

    protected void init(@androidx.annotation.Nullable @Nullable Bundle savedInstanceState, @androidx.annotation.Nullable @Nullable Bundle arguments) {
    }
}

