/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.toolbox.questionanswer;

import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.playback.bean.models.LPQuestionPullResItem;
import com.baijiayun.videoplayer.ui.activity.PBRoomRouterListener;
import com.baijiayun.videoplayer.ui.playback.toolbox.questionanswer.QuestionAnswerContract;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class QuestionAnswerPresenter
implements QuestionAnswerContract.Presenter {
    private PBRoomRouterListener liveRoomRouterListener;
    private Disposable disposableOfQuestionQueue;
    private QuestionAnswerContract.View view;
    private List<LPQuestionPullResItem> questionList = new ArrayList<LPQuestionPullResItem>();

    public QuestionAnswerPresenter(QuestionAnswerContract.View view) {
        this.view = view;
    }

    @Override
    public void setRouter(PBRoomRouterListener liveRoomRouterListener) {
        this.liveRoomRouterListener = liveRoomRouterListener;
    }

    public void subscribe() {
        this.disposableOfQuestionQueue = this.liveRoomRouterListener.getPBRoom().getToolBoxVM().getObservableOfQuestionQueue().subscribe(priorityQueue -> {
            this.questionList.clear();
            this.questionList.addAll((Collection<LPQuestionPullResItem>)priorityQueue);
            this.view.showEmpty(this.questionList.isEmpty());
            this.view.notifyDataChange();
        });
    }

    public void unSubscribe() {
        RxUtils.dispose((Disposable)this.disposableOfQuestionQueue);
    }

    public void destroy() {
        this.unSubscribe();
        this.liveRoomRouterListener = null;
        this.view = null;
    }

    @Override
    public int getCount() {
        return this.questionList.size();
    }

    @Override
    public LPQuestionPullResItem getQuestion(int position) {
        if (position >= this.questionList.size()) {
            return null;
        }
        return this.questionList.get(position);
    }

    @Override
    public void closeFragment() {
        this.liveRoomRouterListener.showQuestionAnswer(false);
    }
}

