/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.adapters;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.text.util.Linkify;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.screen.DisplayUtils;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.DataSource;
import com.baijiayun.glide.load.engine.GlideException;
import com.baijiayun.glide.request.RequestListener;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.playback.bean.models.imodels.IMessageModel;
import com.baijiayun.playback.viewmodel.ChatVM;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.playback.chat.preview.IChatMessageCallback;
import com.baijiayun.videoplayer.ui.playback.chat.utils.CenterImageSpan;
import com.baijiayun.videoplayer.ui.playback.chat.utils.TextLineHeightSpan;
import com.baijiayun.videoplayer.ui.playback.chat.utils.URLImageParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PBMessageAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int MESSAGE_TYPE_TEXT = 0;
    private static final int MESSAGE_TYPE_EMOJI = 1;
    private static final int MESSAGE_TYPE_IMAGE = 2;
    private Context context;
    private int emojiSize;
    private int orientationState;
    private List<IMessageModel> messageModelList = new ArrayList<IMessageModel>();
    private IChatMessageCallback callback;
    private ChatVM chatVM;
    private ImageViewLoadListener imageViewLoadListener;
    private boolean isChatFloatRight;

    public PBMessageAdapter(Context context, IChatMessageCallback callback) {
        this.context = context;
        this.emojiSize = (int)(DisplayUtils.getScreenDensity((Context)context) * 32.0f);
        this.callback = callback;
    }

    public void setImageViewLoadListener(ImageViewLoadListener imageViewLoadListener) {
        this.imageViewLoadListener = imageViewLoadListener;
    }

    public void setChatFloatRight(boolean chatFloatRight) {
        this.isChatFloatRight = chatFloatRight;
    }

    public void setMessageModelList(List<IMessageModel> messageModelList) {
        this.messageModelList.clear();
        this.messageModelList.addAll(messageModelList);
    }

    public void setOrientation(int state) {
        this.orientationState = state;
    }

    public int getItemViewType(int position) {
        switch (this.messageModelList.get(position).getMessageType()) {
            case Text: {
                return 0;
            }
            case Emoji: 
            case EmojiWithName: {
                return 1;
            }
            case Image: {
                return 2;
            }
        }
        return 0;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                View textView = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_pb_item_chat_text, parent, false);
                return new PBTextViewHolder(textView);
            }
            case 2: {
                View imgView = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_pb_item_chat_image, parent, false);
                return new PBImageViewHolder(imgView);
            }
            case 1: {
                View emojiView = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_pb_item_chat_emoji, parent, false);
                return new PBEmojiViewHolder(emojiView);
            }
        }
        View textView = LayoutInflater.from((Context)this.context).inflate(R.layout.bjy_pb_item_chat_text, parent, false);
        return new PBTextViewHolder(textView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        IMessageModel messageModel = this.messageModelList.get(position);
        int color2 = messageModel.getFrom().getType() == LPConstants.LPUserType.Teacher ? ContextCompat.getColor((Context)this.context, (int)R.color.pb_live_blue) : ContextCompat.getColor((Context)this.context, (int)R.color.pb_float_message_name_not_teacher_text);
        String name = UtilsKt.getEncodePhoneNumber((String)messageModel.getFrom().getName()) + "\uff1a";
        SpannableString spanText = new SpannableString((CharSequence)name);
        spanText.setSpan((Object)new ForegroundColorSpan(color2), 0, name.length(), 17);
        if (holder instanceof PBTextViewHolder) {
            PBTextViewHolder textViewHolder = (PBTextViewHolder)holder;
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            if (messageModel.getMessageType() == LPConstants.MessageType.Reward) {
                ssb.append((CharSequence)this.getRewardText(messageModel, textViewHolder.textView, name));
            } else {
                ssb.append((CharSequence)this.getMixText(name + messageModel.getContent(), textViewHolder.textView));
            }
            Paint.FontMetricsInt fontMetricsInt = textViewHolder.textView.getPaint().getFontMetricsInt();
            TextLineHeightSpan lineHeightSpan = new TextLineHeightSpan(fontMetricsInt, 6);
            ssb.setSpan((Object)lineHeightSpan, 0, ssb.length() - 1, 34);
            if (this.orientationState == 2) {
                textViewHolder.container.setBackgroundResource(R.drawable.shape_pb_live_item_chat_blue_bg);
                ssb.setSpan((Object)new ForegroundColorSpan(color2), 0, name.length(), 17);
                ssb.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)this.context, (int)R.color.pb_live_white)), name.length(), ssb.length(), 17);
            } else {
                textViewHolder.container.setBackgroundResource(R.drawable.shape_pb_live_item_chat_bg);
                ssb.setSpan((Object)new ForegroundColorSpan(color2), 0, name.length(), 17);
                ssb.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)this.context, (int)R.color.pb_primary_text)), name.length(), ssb.length(), 17);
            }
            textViewHolder.textView.setText((CharSequence)ssb);
            if (messageModel.getFrom().getType() == LPConstants.LPUserType.Teacher || messageModel.getFrom().getType() == LPConstants.LPUserType.Assistant) {
                Linkify.addLinks((TextView)textViewHolder.textView, (int)3);
            } else {
                textViewHolder.textView.setAutoLinkMask(0);
            }
        } else if (holder instanceof PBImageViewHolder) {
            final PBImageViewHolder imageViewHolder = (PBImageViewHolder)holder;
            imageViewHolder.ivImg.setOnClickListener(null);
            imageViewHolder.tvName.setText((CharSequence)spanText);
            RequestOptions options = new RequestOptions().fitCenter().override(UtilsKt.getDp((int)200), UtilsKt.getDp((int)150));
            Glide.with((Context)this.context).load(messageModel.getUrl()).listener((RequestListener)new RequestListener<Drawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object o, Target<Drawable> target, boolean b) {
                    imageViewHolder.tvExclamation.setVisibility(0);
                    return false;
                }

                public boolean onResourceReady(Drawable drawable2, Object o, Target<Drawable> target, DataSource dataSource, boolean b) {
                    if (PBMessageAdapter.this.imageViewLoadListener != null && PBMessageAdapter.this.orientationState == 2 && PBMessageAdapter.this.isChatFloatRight) {
                        PBMessageAdapter.this.imageViewLoadListener.loadSuccess();
                    }
                    imageViewHolder.tvExclamation.setVisibility(8);
                    return false;
                }
            }).apply(options).into(imageViewHolder.ivImg);
            imageViewHolder.ivImg.setOnClickListener(v -> this.callback.displayImage(messageModel.getUrl()));
            if (this.orientationState == 2) {
                imageViewHolder.chatImageGroup.setBackgroundResource(R.drawable.shape_pb_live_item_chat_blue_bg);
            } else {
                imageViewHolder.chatImageGroup.setBackgroundResource(R.drawable.shape_pb_live_item_chat_bg);
            }
        } else if (holder instanceof PBEmojiViewHolder) {
            PBEmojiViewHolder emojiViewHolder = (PBEmojiViewHolder)holder;
            emojiViewHolder.tvName.setText((CharSequence)spanText);
            RequestOptions options = new RequestOptions().fitCenter().error(R.drawable.emoji_error).override(this.emojiSize, this.emojiSize);
            Glide.with((Context)this.context).load(messageModel.getUrl()).apply(options).into(emojiViewHolder.ivEmoji);
            if (this.orientationState == 2) {
                emojiViewHolder.chatEmojiGroup.setBackgroundResource(R.drawable.shape_pb_live_item_chat_blue_bg);
            } else {
                emojiViewHolder.chatEmojiGroup.setBackgroundResource(R.drawable.shape_pb_live_item_chat_bg);
            }
        }
    }

    public int getItemCount() {
        return this.messageModelList.size();
    }

    private SpannableStringBuilder getMixText(String content, TextView textView) {
        Pattern p = Pattern.compile("\\[[a-zA-Z0-9\u4e00-\u9fa5]+]");
        Matcher m = p.matcher(content);
        SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)content);
        while (m.find()) {
            String group = m.group();
            String url = (String)this.chatVM.getExpressions().get(group.substring(1, group.length() - 1));
            if (TextUtils.isEmpty((CharSequence)url)) continue;
            Drawable drawable2 = new URLImageParser(textView, textView.getTextSize()).getDrawable(url);
            CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
            ssb.setSpan((Object)centerImageSpan, m.start(), m.end(), 34);
            ssb.removeSpan((Object)group);
        }
        return ssb;
    }

    private SpannableStringBuilder getRewardText(IMessageModel message, TextView textView, String name) {
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        ssb.append((CharSequence)name);
        String giftPrefix = textView.getContext().getResources().getString(R.string.bjy_player_show_reward_gift_prefix);
        String cashPrefix = textView.getContext().getResources().getString(R.string.bjy_player_show_reward_cash_prefix);
        String cashSuffix = textView.getContext().getResources().getString(R.string.bjy_player_show_reward_cash_suffix);
        if (TextUtils.isEmpty((CharSequence)message.getData().giftName)) {
            ssb.append((CharSequence)cashPrefix);
            ssb.append((CharSequence)" ");
            ssb.append((CharSequence)"\uffe5");
            ssb.append((CharSequence)message.getData().price);
            ssb.append((CharSequence)" ");
            ssb.append((CharSequence)cashSuffix);
            ssb.setSpan((Object)new StyleSpan(1), cashPrefix.length() + 1, cashPrefix.length() + message.getData().price.length() + 2, 34);
        } else {
            ssb.append((CharSequence)giftPrefix);
            ssb.append((CharSequence)message.getData().giftName);
            ssb.setSpan((Object)new StyleSpan(1), giftPrefix.length(), giftPrefix.length() + message.getData().giftName.length(), 34);
            ssb.append((CharSequence)" ");
            ssb.append((CharSequence)cashSuffix);
            URLImageParser urlImageParser = new URLImageParser(textView, textView.getTextSize());
            Drawable drawable2 = urlImageParser.getDrawable(message.getData().giftImg);
            CenterImageSpan centerImageSpan = new CenterImageSpan(drawable2, 1);
            ssb.setSpan((Object)centerImageSpan, giftPrefix.length() + message.getData().giftName.length() + 1, giftPrefix.length() + message.getData().giftName.length() + cashSuffix.length() + 1, 34);
            ssb.removeSpan((Object)cashSuffix);
        }
        return ssb;
    }

    public void setChatVM(ChatVM chatVM) {
        this.chatVM = chatVM;
    }

    public void destroy() {
        if (this.callback != null) {
            this.callback = null;
        }
        if (this.context != null) {
            this.context = null;
        }
        this.messageModelList.clear();
    }

    public static interface ImageViewLoadListener {
        public void loadSuccess();
    }

    private static class PBEmojiViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvName;
        ImageView ivEmoji;
        LinearLayout chatEmojiGroup;

        PBEmojiViewHolder(View itemView) {
            super(itemView);
            this.tvName = (TextView)itemView.findViewById(R.id.pb_item_chat_emoji_name);
            this.ivEmoji = (ImageView)itemView.findViewById(R.id.pb_item_chat_emoji);
            this.chatEmojiGroup = (LinearLayout)itemView.findViewById(R.id.pb_item_chat_emoji_group);
        }
    }

    private static class PBImageViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvName;
        TextView tvExclamation;
        ImageView ivImg;
        private LinearLayout chatImageGroup;

        PBImageViewHolder(View itemView) {
            super(itemView);
            this.tvName = (TextView)itemView.findViewById(R.id.pb_item_chat_image_name);
            this.ivImg = (ImageView)itemView.findViewById(R.id.pb_item_chat_image);
            this.tvExclamation = (TextView)itemView.findViewById(R.id.pb_item_chat_image_exclamation);
            this.chatImageGroup = (LinearLayout)itemView.findViewById(R.id.pb_item_chat_image_group);
        }
    }

    private static class PBTextViewHolder
    extends RecyclerView.ViewHolder {
        private TextView textView;
        private LinearLayout container;

        PBTextViewHolder(View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(R.id.pb_item_chat_text);
            this.container = (LinearLayout)itemView.findViewById(R.id.pb_item_chat_container);
        }
    }
}

