/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.component.roomoutline;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import com.baijiayun.constant.VideoType;
import com.baijiayun.playback.bean.models.LPKeyFrameModel;
import com.baijiayun.playback.bean.roomOutline.RoomOutlineBean;
import com.baijiayun.playback.ppt.animppt.LPAnimChangeModel;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.component.BaseComponent;
import com.baijiayun.videoplayer.ui.component.roomoutline.MarkFragment;
import com.baijiayun.videoplayer.ui.component.roomoutline.PPTPointsFragment;
import com.baijiayun.videoplayer.ui.databinding.BjyPbLayoutRoomOutlineComponentBinding;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;

public class RoomOutlineComponent
extends BaseComponent {
    private List<RoomOutlineBean> roomOutlineBeanList = new ArrayList<RoomOutlineBean>();
    private List<LPKeyFrameModel> keyFrameModelList = new ArrayList<LPKeyFrameModel>();
    private BjyPbLayoutRoomOutlineComponentBinding binding = BjyPbLayoutRoomOutlineComponentBinding.bind(this.getView());
    private MarkFragment markFragment;
    private PPTPointsFragment pptPointsFragment;

    public RoomOutlineComponent(Context context) {
        super(context);
    }

    @Override
    protected View onCreateComponentView(Context context) {
        return View.inflate((Context)context, (int)R.layout.bjy_pb_layout_room_outline_component, null);
    }

    private void initViewPager() {
        this.binding.closeIv.setOnClickListener(v -> this.binding.bjplayerRlRoomOutlineContainer.setVisibility(8));
        final ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        final ArrayList<String> tabs = new ArrayList<String>();
        if (this.roomOutlineBeanList.isEmpty() || this.keyFrameModelList.isEmpty()) {
            this.binding.viewDiv.setVisibility(4);
            this.binding.tabLayout.setVisibility(4);
        }
        if (!this.keyFrameModelList.isEmpty()) {
            this.markFragment = MarkFragment.Companion.newInstance(this.keyFrameModelList);
            fragments.add(this.markFragment);
            tabs.add(this.getContext().getString(R.string.bjy_pb_playback_points_mark));
        }
        if (!this.roomOutlineBeanList.isEmpty()) {
            this.pptPointsFragment = PPTPointsFragment.Companion.newInstance(this.roomOutlineBeanList);
            fragments.add(this.pptPointsFragment);
            tabs.add(this.getContext().getString(R.string.bjy_pb_playback_ppt_points));
        }
        SeekEventRunnable seekEventRunnable = new SeekEventRunnable();
        if (this.markFragment != null) {
            this.markFragment.setOnItemClickListener((Function2<? super View, ? super Integer, Unit>)((Function2)(view, progress) -> {
                seekEventRunnable.setSeekProgress((int)progress);
                this.getView().removeCallbacks((Runnable)seekEventRunnable);
                this.getView().postDelayed((Runnable)seekEventRunnable, 300L);
                return null;
            }));
        }
        if (this.pptPointsFragment != null) {
            this.pptPointsFragment.setOnItemClickListener((Function2<? super View, ? super Integer, Unit>)((Function2)(view, progress) -> {
                seekEventRunnable.setSeekProgress((int)progress);
                this.getView().removeCallbacks((Runnable)seekEventRunnable);
                this.getView().postDelayed((Runnable)seekEventRunnable, 300L);
                return null;
            }));
        }
        int selectedColor = -1;
        int normalColor = Color.parseColor((String)"#99FFFFFF");
        this.binding.tabLayout.setTabTextColors(normalColor, selectedColor);
        this.binding.viewPager.setAdapter((PagerAdapter)new FragmentPagerAdapter(((FragmentActivity)this.getContext()).getSupportFragmentManager(), 0){

            @NonNull
            public Fragment getItem(int position) {
                return (Fragment)fragments.get(position);
            }

            public int getCount() {
                return fragments.size();
            }

            @Nullable
            public CharSequence getPageTitle(int position) {
                return (CharSequence)tabs.get(position);
            }
        });
        this.binding.tabLayout.setupWithViewPager(this.binding.viewPager);
    }

    @Override
    public void onCustomEvent(int eventCode, Bundle bundle) {
        super.onCustomEvent(eventCode, bundle);
        switch (eventCode) {
            case -80029: {
                Serializable roomOutlineData = bundle.getSerializable("room_outline_data");
                Serializable markData = bundle.getSerializable("mark_data");
                if (roomOutlineData != null) {
                    this.roomOutlineBeanList = (List)((Object)roomOutlineData);
                }
                if (markData != null) {
                    this.keyFrameModelList = (List)((Object)markData);
                }
                this.initViewPager();
                LPAnimChangeModel lpAnimChangeModel = (LPAnimChangeModel)bundle.getSerializable("page_change_cache");
                if (lpAnimChangeModel == null) break;
                this.onPageChange(lpAnimChangeModel.docId, lpAnimChangeModel.offsetTimeStampMs);
                break;
            }
            case -80031: {
                String docId = bundle.getString("doc_id");
                int timestampMs = bundle.getInt("offset_timestamp_ms");
                this.onPageChange(docId, timestampMs);
                break;
            }
        }
    }

    @Override
    public void onComponentEvent(int eventCode, Bundle bundle) {
        super.onComponentEvent(eventCode, bundle);
        if (eventCode == -80023) {
            int reqFunc = bundle.getInt("req_toggle_menu", -1);
            switch (reqFunc) {
                case -80030: {
                    this.binding.bjplayerRlRoomOutlineContainer.setVisibility(0);
                    break;
                }
                case -80027: {
                    this.binding.bjplayerRlRoomOutlineContainer.setVisibility(8);
                    break;
                }
            }
        } else if (eventCode == -80034) {
            this.binding.bjplayerRlRoomOutlineContainer.setVisibility(8);
        }
    }

    @Override
    public void bindVideoPlayer(IBJYVideoPlayer videoPlayer) {
        super.bindVideoPlayer(videoPlayer);
        videoPlayer.addOnVideoTypeChangeListener(videoType -> {
            if (videoType != VideoType.ContentVideo) {
                this.setComponentVisibility(8);
            } else {
                this.setComponentVisibility(0);
            }
        });
        if (videoPlayer.getVideoType() != VideoType.ContentVideo) {
            this.setComponentVisibility(8);
        } else {
            this.setComponentVisibility(0);
        }
    }

    @Override
    public void onPlayerEvent(int eventCode, Bundle bundle) {
        super.onPlayerEvent(eventCode, bundle);
        switch (eventCode) {
            case -99019: {
                int data = bundle.getInt("int_data");
                int selectedPosition = 0;
                Collections.sort(this.keyFrameModelList, (o1, o2) -> VideoPlayerUtils.formatDuration((String)o1.timeOffset) - VideoPlayerUtils.formatDuration((String)o2.timeOffset));
                for (int i = this.keyFrameModelList.size() - 1; i >= 0; --i) {
                    if (data < VideoPlayerUtils.formatDuration((String)this.keyFrameModelList.get((int)i).timeOffset)) continue;
                    selectedPosition = i;
                    break;
                }
                if (this.markFragment == null) break;
                this.markFragment.updateSelectedItem(selectedPosition);
                break;
            }
        }
    }

    private void onPageChange(String docId, int timestampMs) {
        timestampMs = Math.max(0, timestampMs);
        for (int i = 0; i < this.roomOutlineBeanList.size(); ++i) {
            if (this.roomOutlineBeanList.get(i).getType() == 0 || !TextUtils.equals((CharSequence)this.roomOutlineBeanList.get(i).getDocId(), (CharSequence)docId)) continue;
            if (timestampMs < this.roomOutlineBeanList.get(i).getOffsetTimeStampMs()) {
                if (this.pptPointsFragment == null) break;
                if (i == 0) {
                    this.pptPointsFragment.updateSelectedItem(0);
                    break;
                }
                this.pptPointsFragment.updateSelectedItem(i - 1);
                break;
            }
            if (i != this.roomOutlineBeanList.size() - 1 || this.pptPointsFragment == null) continue;
            this.pptPointsFragment.updateSelectedItem(i);
        }
    }

    @Override
    protected void setKey() {
        this.key = "room_outline_component";
    }

    class SeekEventRunnable
    implements Runnable {
        private int seekProgress;

        public SeekEventRunnable() {
        }

        public SeekEventRunnable(int seekProgress) {
            this.seekProgress = seekProgress;
        }

        public void setSeekProgress(int seekProgress) {
            this.seekProgress = seekProgress;
        }

        @Override
        public void run() {
            if (this.seekProgress < 0) {
                return;
            }
            Bundle bundle = BundlePool.obtain();
            bundle.putInt("int_data", this.seekProgress);
            RoomOutlineComponent.this.requestSeek(bundle);
        }
    }
}

