/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.toolbox.answersheet;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.query.QueryPlus;
import com.baijiayun.livebase.base.BaseFragment;
import com.baijiayun.playback.bean.models.LPAnswerSheetOptionModel;
import com.baijiayun.videoplayer.ui.R;
import com.baijiayun.videoplayer.ui.playback.toolbox.answersheet.QuestionToolContract;
import java.util.ArrayList;
import java.util.List;

public class QuestionToolFragment
extends BaseFragment
implements QuestionToolContract.View {
    private QuestionToolContract.Presenter presenter;
    private LinearLayout newLayout;
    List<TextView> buttonOptionList = new ArrayList<TextView>();

    public int getLayoutId() {
        return R.layout.bjy_pb_dialog_question_tool;
    }

    protected void init(Bundle savedInstanceState) {
        this.$ = QueryPlus.with((View)this.view);
        int index = 0;
        this.$.id(R.id.dialog_close).clicked(v -> this.presenter.removeQuestionTool(false));
        this.$.id(R.id.dialog_question_tool_desc).visibility(TextUtils.isEmpty((CharSequence)this.presenter.getDesc()) ? 8 : 0);
        this.$.id(R.id.dialog_question_tool_desc).text((CharSequence)this.presenter.getDesc());
        this.$.id(R.id.dialog_btn_submit).clicked(v -> {
            if (this.presenter.submitAnswers()) {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u63d0\u4ea4\u6210\u529f\uff01", (int)0).show();
                this.presenter.removeQuestionTool(true);
            } else {
                Toast.makeText((Context)this.getContext(), (CharSequence)"\u8bf7\u9009\u62e9\u9009\u9879", (int)0).show();
            }
        });
        LinearLayout optionsLayout = (LinearLayout)this.$.id(R.id.dialog_question_tool_options).view();
        if (this.presenter != null && this.presenter.getOptions() != null && !this.presenter.getOptions().isEmpty()) {
            for (LPAnswerSheetOptionModel model : this.presenter.getOptions()) {
                TextView buttonOption = new TextView(this.getContext());
                buttonOption.setText((CharSequence)model.text);
                buttonOption.setTextColor(this.getResources().getColor(R.color.live_blue));
                buttonOption.setBackgroundResource(R.drawable.live_question_tool_rectoption_unchecked);
                buttonOption.setGravity(17);
                buttonOption.setTag((Object)true);
                buttonOption.setMinWidth(UtilsKt.getDp((int)32));
                int padding = UtilsKt.getDp((int)6);
                buttonOption.setPadding(padding, padding, padding, padding);
                int currentIndex = index;
                buttonOption.setOnClickListener(v -> {
                    if (((Boolean)buttonOption.getTag()).booleanValue()) {
                        buttonOption.setBackgroundResource(R.drawable.live_question_tool_rectoption_checked);
                        buttonOption.setTextColor(this.getResources().getColor(R.color.live_white));
                        buttonOption.setTag((Object)false);
                        this.presenter.addCheckedOption(currentIndex);
                    } else {
                        this.uncheckOption(buttonOption);
                        this.presenter.deleteCheckedOption(currentIndex);
                    }
                    if (this.checkSingleOption(this.presenter.getOptions())) {
                        for (int i = 0; i < this.buttonOptionList.size(); ++i) {
                            if (i == currentIndex) continue;
                            this.uncheckOption(this.buttonOptionList.get(i));
                            this.presenter.deleteCheckedOption(i);
                        }
                    }
                });
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, UtilsKt.getDp((int)32));
                if (index % 4 == 0) {
                    this.newLayout = new LinearLayout(this.getContext());
                    this.newLayout.setOrientation(0);
                    this.newLayout.setGravity(1);
                    LinearLayout.LayoutParams newLayoutParams = new LinearLayout.LayoutParams(-1, -2);
                    newLayoutParams.setMargins(UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), UtilsKt.getDp((int)8), UtilsKt.getDp((int)8));
                    optionsLayout.setOrientation(1);
                    optionsLayout.addView((View)this.newLayout, (ViewGroup.LayoutParams)newLayoutParams);
                }
                layoutParams.setMargins(UtilsKt.getDp((int)8), 0, UtilsKt.getDp((int)8), 0);
                if (this.newLayout != null) {
                    layoutParams.gravity = 1;
                    this.newLayout.addView((View)buttonOption, (ViewGroup.LayoutParams)layoutParams);
                }
                this.buttonOptionList.add(buttonOption);
                ++index;
            }
        }
    }

    private void uncheckOption(TextView optionTextView) {
        optionTextView.setTextColor(this.getResources().getColor(R.color.live_blue));
        optionTextView.setBackgroundResource(R.drawable.live_question_tool_rectoption_unchecked);
        optionTextView.setTag((Object)true);
    }

    private boolean checkSingleOption(List<LPAnswerSheetOptionModel> options) {
        int rightCount = 0;
        for (LPAnswerSheetOptionModel optionModel : options) {
            if (optionModel.isCorrect || optionModel.isRight) {
                ++rightCount;
            }
            if (rightCount < 2) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setPresenter(QuestionToolContract.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void timeDown(String down) {
        ((TextView)this.$.id(R.id.dialog_question_tool_countDown).view()).setText((CharSequence)down);
    }

    public void onDestroy() {
        super.onDestroy();
        this.presenter = null;
        this.buttonOptionList.clear();
    }
}

