/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.widget;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.PopupWindow;

public class FloatingView
extends FrameLayout
implements GestureDetector.OnGestureListener {
    private Context mContext;
    private WindowManager mWindowManager;
    private GestureDetector mGestureDetector;
    private WindowManager.LayoutParams mLayoutParams;
    private float mLastX;
    private float mLastY;
    private PopupWindow mPopupWindow;
    private long mTapOutsideTime;
    private boolean mIsShowing;

    public FloatingView(Context context) {
        super(context);
        this.mContext = context;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
    }

    public FloatingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
    }

    public FloatingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
    }

    public FloatingView(Context context, int viewResId) {
        super(context);
        this.mContext = context;
        View.inflate((Context)context, (int)viewResId, (ViewGroup)this);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
    }

    public FloatingView(Context context, View view) {
        super(context);
        this.mContext = context;
        this.addView(view);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
    }

    private void showView(View view) {
        this.showView(view, -2, -2, 0, 0);
    }

    private void showView(View view, int width, int height, int offsetX, int offsetY) {
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        int type = 2005;
        if (Build.VERSION.SDK_INT >= 26) {
            type = 2038;
        } else if (Build.VERSION.SDK_INT > 24) {
            type = 2002;
        }
        this.mLayoutParams = new WindowManager.LayoutParams(type);
        this.mLayoutParams.flags = 8;
        this.mLayoutParams.flags |= 0x40000;
        this.mLayoutParams.width = width;
        this.mLayoutParams.height = height;
        this.mLayoutParams.x += offsetX;
        this.mLayoutParams.y += offsetY;
        this.mLayoutParams.gravity = 0x800033;
        this.mLayoutParams.format = -3;
        this.mWindowManager.addView(view, (ViewGroup.LayoutParams)this.mLayoutParams);
    }

    public void hideView() {
        if (null != this.mWindowManager) {
            this.mWindowManager.removeViewImmediate((View)this);
        }
        this.mWindowManager = null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mGestureDetector.onTouchEvent(event);
    }

    public boolean onDown(MotionEvent e) {
        this.mLastX = e.getRawX();
        this.mLastY = e.getRawY();
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        float nowX = e2.getRawX();
        float nowY = e2.getRawY();
        float tranX = nowX - this.mLastX;
        float tranY = nowY - this.mLastY;
        this.mLayoutParams.x = (int)((float)this.mLayoutParams.x + tranX);
        this.mLayoutParams.y = (int)((float)this.mLayoutParams.y + tranY);
        this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mLayoutParams);
        this.mLastX = nowX;
        this.mLastY = nowY;
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }

    public void setPopupWindow(int id2) {
        this.mPopupWindow = new PopupWindow((View)this);
        this.mPopupWindow.setWidth(-2);
        this.mPopupWindow.setHeight(-2);
        this.mPopupWindow.setTouchable(true);
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setFocusable(false);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.mPopupWindow.setContentView(LayoutInflater.from((Context)this.getContext()).inflate(id2, null));
        this.mPopupWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 4) {
                    FloatingView.this.mPopupWindow.dismiss();
                    FloatingView.this.mTapOutsideTime = System.currentTimeMillis();
                    return true;
                }
                return false;
            }
        });
    }

    public View getPopupView() {
        return this.mPopupWindow.getContentView();
    }

    public void setOnPopupItemClickListener(View.OnClickListener listener) {
        if (this.mPopupWindow == null) {
            return;
        }
        ViewGroup layout2 = (ViewGroup)this.mPopupWindow.getContentView();
        for (int i = 0; i < layout2.getChildCount(); ++i) {
            layout2.getChildAt(i).setOnClickListener(listener);
        }
    }

    public void show() {
        if (!this.mIsShowing) {
            this.showView((View)this);
        }
        this.mIsShowing = true;
    }

    public void show(int width, int height, int offsetX, int offsetY) {
        if (!this.mIsShowing) {
            this.showView((View)this, width, height, offsetX, offsetY);
        }
        this.mIsShowing = true;
    }

    public void dismiss() {
        if (this.mIsShowing) {
            this.hideView();
        }
        this.mIsShowing = false;
        if (this.mPopupWindow != null) {
            ViewGroup layout2 = (ViewGroup)this.mPopupWindow.getContentView();
            for (int i = 0; i < layout2.getChildCount(); ++i) {
                layout2.getChildAt(i).setOnClickListener(null);
            }
        }
    }

    public boolean onSingleTapUp(MotionEvent e) {
        if (null != this.mPopupWindow) {
            this.mPopupWindow.dismiss();
        }
        if (this.mPopupWindow != null && System.currentTimeMillis() - this.mTapOutsideTime >= 80L) {
            this.mPopupWindow.showAtLocation((View)this, 0, 100, 0);
        }
        return false;
    }
}

