/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.widget;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.playback.ppt.animppt.LPAnimChangeModel;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.listeners.OnBufferingListener;
import com.baijiayun.videoplayer.ui.component.roomoutline.RoomOutlineComponent;
import com.baijiayun.videoplayer.ui.listener.IRetryEnterRoomCallback;
import com.baijiayun.videoplayer.ui.utils.NetworkUtils;
import com.baijiayun.videoplayer.ui.widget.BaseVideoView;
import com.baijiayun.videoplayer.ui.widget.ComponentContainer;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.PublishSubject;
import java.io.Serializable;
import java.util.ArrayList;

public class BJYPlaybackContainer
extends BaseVideoView {
    private FrameLayout pptOrVideoContainer;
    private IRetryEnterRoomCallback retryEnterRoomCallback;
    private PBRoom pbRoom;
    private Disposable pageChangeSubscription;
    private Disposable disposableOfRoomOutline;
    private PublishSubject<Integer> subjectOfPlayingTime;
    private LPAnimChangeModel pageChangeCache;
    private GestureDetector pptPlayerGestureDetector;
    private boolean mPPTTouchEnable;

    public BJYPlaybackContainer(@NonNull Context context) {
        this(context, null);
    }

    public BJYPlaybackContainer(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BJYPlaybackContainer(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(Context context, AttributeSet attributeSet, int defStyleAttr) {
        super.init(context, attributeSet, defStyleAttr);
        this.pptOrVideoContainer = new FrameLayout(context);
        this.addView((View)this.pptOrVideoContainer, new ViewGroup.LayoutParams(-1, -1));
        this.subjectOfPlayingTime = PublishSubject.create();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mPPTTouchEnable) {
            boolean handle = this.componentContainer.dispatchTouchEvent(ev);
            if (!handle) {
                this.pptPlayerGestureDetector.onTouchEvent(ev);
                return this.pptOrVideoContainer.dispatchTouchEvent(ev);
            }
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }

    public void attachPBRoom(PBRoom pbRoom) {
        this.pbRoom = pbRoom;
        this.attachVideoPlayer(pbRoom.getPlayer());
        this.addDefaultComponent();
    }

    public void addDefaultComponent() {
        this.componentContainer = new ComponentContainer(this.pbRoom, this.getContext());
        this.componentContainer.init(this.bjyVideoPlayer, true);
        this.addView((View)this.componentContainer, new ViewGroup.LayoutParams(-1, -1));
        this.componentContainer.setOnComponentEventListener(this.internalComponentEventListener);
        this.componentContainer.dispatchCustomEvent(-80032, null);
        if (this.useDefaultNetworkListener) {
            this.registerNetChangeReceiver();
        }
        this.pptPlayerGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapConfirmed(@NonNull MotionEvent e) {
                BJYPlaybackContainer.this.componentContainer.dispatchSingleTapEvent(e);
                return super.onSingleTapConfirmed(e);
            }
        });
    }

    public void attachVideoPlayer(IBJYVideoPlayer bjyVideoPlayer) {
        super.initPlayer(bjyVideoPlayer);
        bjyVideoPlayer.addOnBufferingListener(new OnBufferingListener(){

            public void onBufferingStart() {
                BJYPlaybackContainer.this.componentContainer.dispatchPlayEvent(-80010, null);
            }

            public void onBufferingEnd() {
                BJYPlaybackContainer.this.componentContainer.dispatchPlayEvent(-80011, null);
            }
        });
        bjyVideoPlayer.addOnPlayerErrorListener(error -> {
            Bundle bundle = BundlePool.obtain();
            bundle.putString("string_data", error.getMessage());
            this.componentContainer.dispatchErrorEvent(error.getCode(), bundle);
        });
        bjyVideoPlayer.addOnPlayingTimeChangeListener((currentTime, duration) -> {
            this.subjectOfPlayingTime.onNext((Object)currentTime);
            Bundle bundle = BundlePool.obtain((int)currentTime);
            this.componentContainer.dispatchPlayEvent(component -> "controller_component".equals(component.getKey()) || "room_outline_component".equals(component.getKey()), -99019, bundle);
        });
        bjyVideoPlayer.addOnSeekCompleteListener((beforeSeekPosition, seekPosition) -> {
            Bundle bundle = BundlePool.obtain((int)seekPosition);
            this.componentContainer.dispatchPlayEvent(component -> "controller_component".equals(component.getKey()) || "room_outline_component".equals(component.getKey()), -99019, bundle);
        });
        if (this.pbRoom != null) {
            this.pageChangeSubscription = this.pbRoom.getDocListVM().getObservableOfDocPageIndex().observeOn(AndroidSchedulers.mainThread()).subscribe(lpAnimChangeModel -> {
                this.pageChangeCache = lpAnimChangeModel;
                Bundle bundle = new Bundle();
                bundle.putString("doc_id", lpAnimChangeModel.docId);
                bundle.putInt("offset_timestamp_ms", lpAnimChangeModel.offsetTimeStampMs);
                this.componentContainer.dispatchCustomEvent(-80031, bundle);
            });
            this.disposableOfRoomOutline = this.pbRoom.getDocListVM().getObservableOfRoomOutline().observeOn(AndroidSchedulers.mainThread()).subscribe(roomOutlineBeans -> {
                boolean isScreenRecorderClass = this.pbRoom.getRecordType() == 2 && this.pbRoom.getSmallCourseRecordType() == 0;
                Bundle roomOutlineDataBundle = new Bundle();
                if (roomOutlineBeans == null || roomOutlineBeans.size() == 0) {
                    if (this.pbRoom.getKeyFrameModelList() != null && !this.pbRoom.getKeyFrameModelList().isEmpty()) {
                        roomOutlineDataBundle.putSerializable("mark_data", (Serializable)((Object)this.pbRoom.getKeyFrameModelList()));
                        if (this.pageChangeCache != null) {
                            roomOutlineDataBundle.putSerializable("page_change_cache", (Serializable)this.pageChangeCache);
                        }
                        this.componentContainer.dispatchCustomEvent(-80028, BundlePool.obtain((!isScreenRecorderClass ? 1 : 0) != 0));
                        this.componentContainer.dispatchCustomEvent(-80029, roomOutlineDataBundle);
                    } else {
                        this.componentContainer.dispatchCustomEvent(-80028, BundlePool.obtain((boolean)false));
                    }
                } else {
                    this.componentContainer.dispatchCustomEvent(-80028, BundlePool.obtain((!isScreenRecorderClass ? 1 : 0) != 0));
                    this.componentContainer.addComponent("room_outline_component", new RoomOutlineComponent(this.getContext()));
                    roomOutlineDataBundle.putSerializable("room_outline_data", (Serializable)((Object)roomOutlineBeans));
                    if (this.pageChangeCache != null) {
                        roomOutlineDataBundle.putSerializable("page_change_cache", (Serializable)this.pageChangeCache);
                    }
                    if (this.pbRoom.getKeyFrameModelList() != null && !this.pbRoom.getKeyFrameModelList().isEmpty()) {
                        roomOutlineDataBundle.putSerializable("mark_data", (Serializable)((Object)this.pbRoom.getKeyFrameModelList()));
                    }
                    this.componentContainer.dispatchCustomEvent(-80029, roomOutlineDataBundle);
                }
            });
        }
    }

    public void addCubChangeListener() {
        this.bjyVideoPlayer.addCubChangeListener(cues -> {
            Bundle bundle = BundlePool.obtain();
            bundle.putParcelableArrayList("subtitle", (ArrayList)cues);
            this.componentContainer.dispatchCustomEvent(component -> component.getKey().equals("controller_component"), -80019, bundle);
        });
    }

    @Override
    protected void requestPlayAction() {
        super.requestPlayAction();
        if (!(this.pbRoom == null || this.pbRoom.isPlaybackOffline() || this.bjyVideoPlayer.getVideoInfo() != null && this.bjyVideoPlayer.getVideoInfo().getVideoId() != 0L)) {
            if (this.retryEnterRoomCallback != null) {
                this.retryEnterRoomCallback.retryEnterRoom();
            }
        } else {
            this.bjyVideoPlayer.play();
        }
    }

    public void addPPTView(View view, FrameLayout.LayoutParams params) {
        this.pptOrVideoContainer.removeAllViews();
        this.pptOrVideoContainer.addView(view, (ViewGroup.LayoutParams)params);
    }

    public boolean containPPTView(View view) {
        return this.indexOfChild((View)this.pptOrVideoContainer) != -1 && this.pptOrVideoContainer.indexOfChild(view) != -1;
    }

    public void setGestureEnable(boolean enable) {
        this.componentContainer.setGestureEnable(enable);
    }

    public void setPPTTouchEnable(boolean enable) {
        this.mPPTTouchEnable = enable;
        this.setGestureEnable(!enable);
    }

    public boolean checkNetState() {
        if (!this.enablePlayWithMobileNetwork && NetworkUtils.isMobile(NetworkUtils.getNetworkState(this.getContext()))) {
            this.sendCustomEvent(-80012, null);
            return false;
        }
        return true;
    }

    public void setRetryEnterRoomCallback(IRetryEnterRoomCallback retryEnterRoomCallback) {
        this.retryEnterRoomCallback = retryEnterRoomCallback;
    }

    public Observable<Integer> getObservablePlayingTime() {
        return this.subjectOfPlayingTime;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.retryEnterRoomCallback = null;
        RxUtils.dispose((Disposable)this.pageChangeSubscription);
        RxUtils.dispose((Disposable)this.disposableOfRoomOutline);
    }
}

