/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.announcement;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewStub;
import android.widget.TextView;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.livebase.base.BaseDialogFragment;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.playback.bean.models.roomresponse.LPResRoomNoticeModel;
import com.baijiayun.videoplayer.ui.R;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import java.io.Serializable;

public class AnnouncementFragment
extends BaseDialogFragment {
    public static final String SERIALIZABLE_KEY = "announcement";
    private final CompositeDisposable compositeDisposable = new CompositeDisposable();
    private PBRoom pbRoom;
    private TextView announcementTv;
    private TextView tipsTv;
    private ViewStub viewStub;
    private View emptyView;
    private LPResRoomNoticeModel announcementModel;

    public static AnnouncementFragment newInstance(LPResRoomNoticeModel announcementModel) {
        AnnouncementFragment announcementFragment = new AnnouncementFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(SERIALIZABLE_KEY, (Serializable)announcementModel);
        announcementFragment.setArguments(bundle);
        return announcementFragment;
    }

    public void setPbRoom(PBRoom pbRoom) {
        this.pbRoom = pbRoom;
    }

    protected int getLayoutId() {
        return R.layout.bjy_pb_announcement;
    }

    protected void init(Bundle savedInstanceState, Bundle arguments) {
        super.title(this.getResources().getString(R.string.bjy_player_announcement));
        super.editable(false);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.announcementModel = (LPResRoomNoticeModel)bundle.getSerializable(SERIALIZABLE_KEY);
        }
        this.announcementTv = (TextView)this.contentView.findViewById(R.id.tv_announcement_notice_info);
        this.tipsTv = (TextView)this.contentView.findViewById(R.id.tv_announcement_notice_info_tips);
        this.viewStub = (ViewStub)this.contentView.findViewById(R.id.empty_announcement_layout);
        this.announcementTv.setOnClickListener(v -> {
            if (this.announcementModel != null && !TextUtils.isEmpty((CharSequence)this.announcementModel.getLink())) {
                UtilsKt.startActivityByUrl((Context)this.getContext(), (String)this.announcementModel.getLink());
            }
        });
        if (this.announcementModel == null) {
            this.getEmptyView().setVisibility(0);
        } else {
            this.onAnnouncementReceived();
        }
        this.subscribe();
    }

    private void subscribe() {
        this.compositeDisposable.add(this.pbRoom.getObservableOfAnnouncementChange().observeOn(AndroidSchedulers.mainThread()).subscribe(iAnnouncementModel -> {
            this.getEmptyView().setVisibility(8);
            this.announcementModel = (LPResRoomNoticeModel)iAnnouncementModel;
            this.onAnnouncementReceived();
        }));
    }

    public void onDestroy() {
        super.onDestroy();
        this.emptyView = null;
        this.compositeDisposable.dispose();
    }

    private View getEmptyView() {
        if (this.emptyView == null) {
            this.emptyView = this.viewStub.inflate();
        }
        return this.emptyView;
    }

    private void onAnnouncementReceived() {
        this.announcementTv.setText((CharSequence)this.announcementModel.getContent());
        this.tipsTv.setVisibility(TextUtils.isEmpty((CharSequence)this.announcementModel.getLink()) ? 8 : 0);
    }
}

