/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.activity;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.reactivex.RxUtils;
import com.baijiayun.playback.dataloader.PlayerDataLoader;
import com.baijiayun.playback.util.PBJsonUtils;
import com.baijiayun.videoplayer.bean.VideoItem;
import com.baijiayun.videoplayer.event.BundlePool;
import com.baijiayun.videoplayer.render.AspectRatio;
import com.baijiayun.videoplayer.ui.activity.BaseActivity;
import com.baijiayun.videoplayer.ui.activity.VideoListActivity;
import com.baijiayun.videoplayer.ui.bean.VideoInfoModel;
import com.baijiayun.videoplayer.ui.databinding.BjyPbActivityVideoListBinding;
import com.baijiayun.videoplayer.ui.listener.CallbackManager;
import com.baijiayun.videoplayer.ui.videoplayer.adapter.VideoAdapter;
import com.baijiayun.videoplayer.ui.videoplayer.adapter.VideoViewHolder;
import com.baijiayun.videoplayer.ui.widget.BJYVideoView;
import com.google.gson.reflect.TypeToken;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010-\u001a\u00020\u000fH\u0014J\b\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020/H\u0002J\u0012\u00101\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u000103H\u0014J\b\u00104\u001a\u00020/H\u0014J\u0012\u00105\u001a\u00020/2\b\b\u0002\u00106\u001a\u00020\u0013H\u0002J\u0010\u00107\u001a\u00020/2\u0006\u00108\u001a\u00020!H\u0002J\b\u00109\u001a\u00020\u0013H\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\n\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\n\u001a\u0004\b\u001c\u0010\u001dR\u001e\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010#\u001a\u001e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$j\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&`'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\n\u001a\u0004\b*\u0010+\u00a8\u0006:"}, d2={"Lcom/baijiayun/videoplayer/ui/activity/VideoListActivity;", "Lcom/baijiayun/videoplayer/ui/activity/BaseActivity;", "()V", "_binding", "Lcom/baijiayun/videoplayer/ui/databinding/BjyPbActivityVideoListBinding;", "adapter", "Lcom/baijiayun/videoplayer/ui/videoplayer/adapter/VideoAdapter;", "getAdapter", "()Lcom/baijiayun/videoplayer/ui/videoplayer/adapter/VideoAdapter;", "adapter$delegate", "Lkotlin/Lazy;", "binding", "getBinding", "()Lcom/baijiayun/videoplayer/ui/databinding/BjyPbActivityVideoListBinding;", "currentPosition", "", "disposableOfLoadVideoInfo", "Lio/reactivex/disposables/Disposable;", "isDownScroll", "", "layoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "getLayoutManager", "()Landroidx/recyclerview/widget/LinearLayoutManager;", "layoutManager$delegate", "loadVideoInfoDisposable", "snapHelper", "Landroidx/recyclerview/widget/PagerSnapHelper;", "getSnapHelper", "()Landroidx/recyclerview/widget/PagerSnapHelper;", "snapHelper$delegate", "videoInfoModelList", "Ljava/util/ArrayList;", "Lcom/baijiayun/videoplayer/ui/bean/VideoInfoModel;", "Lkotlin/collections/ArrayList;", "videoItemMap", "Ljava/util/HashMap;", "", "Lcom/baijiayun/videoplayer/bean/VideoItem;", "Lkotlin/collections/HashMap;", "videoView", "Lcom/baijiayun/videoplayer/ui/widget/BJYVideoView;", "getVideoView", "()Lcom/baijiayun/videoplayer/ui/widget/BJYVideoView;", "videoView$delegate", "getScreenOrientationAllow", "initData", "", "initView", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "play", "forcePlay", "preloadNextItem", "videoInfoModel", "supportWifiAnim", "videoplayer-ui_release"})
public final class VideoListActivity
extends BaseActivity {
    @Nullable
    private BjyPbActivityVideoListBinding _binding;
    private int currentPosition = -1;
    @NotNull
    private ArrayList<VideoInfoModel> videoInfoModelList = new ArrayList();
    @NotNull
    private HashMap<String, VideoItem> videoItemMap = new HashMap();
    @NotNull
    private final Lazy adapter$delegate = LazyKt.lazy((Function0)adapter.2.INSTANCE);
    @NotNull
    private final Lazy videoView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BJYVideoView>(this){
        final /* synthetic */ VideoListActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final BJYVideoView invoke() {
            BJYVideoView bjyVideoView = new BJYVideoView((Context)this.this$0);
            bjyVideoView.setAspectRatio(AspectRatio.AspectRatio_FIT_PARENT);
            bjyVideoView.setRenderType(0);
            return bjyVideoView;
        }
    }));
    @NotNull
    private final Lazy snapHelper$delegate = LazyKt.lazy((Function0)snapHelper.2.INSTANCE);
    @NotNull
    private final Lazy layoutManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LinearLayoutManager>(this){
        final /* synthetic */ VideoListActivity this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final LinearLayoutManager invoke() {
            return new LinearLayoutManager((Context)this.this$0);
        }
    }));
    @Nullable
    private Disposable disposableOfLoadVideoInfo;
    @Nullable
    private Disposable loadVideoInfoDisposable;
    private boolean isDownScroll;

    private final BjyPbActivityVideoListBinding getBinding() {
        BjyPbActivityVideoListBinding bjyPbActivityVideoListBinding = this._binding;
        Intrinsics.checkNotNull((Object)bjyPbActivityVideoListBinding);
        return bjyPbActivityVideoListBinding;
    }

    private final VideoAdapter getAdapter() {
        Lazy lazy = this.adapter$delegate;
        return (VideoAdapter)((Object)lazy.getValue());
    }

    private final BJYVideoView getVideoView() {
        Lazy lazy = this.videoView$delegate;
        return (BJYVideoView)((Object)lazy.getValue());
    }

    private final PagerSnapHelper getSnapHelper() {
        Lazy lazy = this.snapHelper$delegate;
        return (PagerSnapHelper)lazy.getValue();
    }

    private final LinearLayoutManager getLayoutManager() {
        Lazy lazy = this.layoutManager$delegate;
        return (LinearLayoutManager)lazy.getValue();
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        BJYPlayerSDK.isVideoList = true;
        this._binding = BjyPbActivityVideoListBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.getBinding().getRoot());
        Window window = this.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
        UtilsKt.immersiveStatusBar((Window)window);
        this.initData();
        this.initView();
    }

    private final void initData() {
        this.currentPosition = this.getIntent().getIntExtra("pb_room_video_position", 0);
        String json = this.getIntent().getStringExtra("pb_room_video_model_list");
        Object object = PBJsonUtils.gson.fromJson(json, new TypeToken<List<? extends VideoInfoModel>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(json, obje\u2026deoInfoModel>>() {}.type)");
        this.videoInfoModelList = (ArrayList)object;
    }

    private final void initView() {
        this.getVideoView().initPlayer(this.bjyVideoPlayer);
        Bundle bundle = BundlePool.obtain();
        bundle.putSerializable("videoConfig", (Serializable)this.videoPlayerConfig);
        this.getVideoView().sendCustomEvent(-80049, bundle);
        this.getSnapHelper().attachToRecyclerView(this.getBinding().recyclerView);
        this.getBinding().recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getLayoutManager());
        this.getBinding().recyclerView.setAdapter((RecyclerView.Adapter)this.getAdapter());
        this.disposableOfLoadVideoInfo = this.bjyVideoPlayer.getLoadVideoInfoObservable().observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> VideoListActivity.initView$lambda$0((Function1)new Function1<VideoItem, Unit>(this){
            final /* synthetic */ VideoListActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(VideoItem it) {
                Map map = VideoListActivity.access$getVideoItemMap$p(this.this$0);
                String string2 = String.valueOf(it.videoId);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                map.put(string2, it);
            }
        }, arg_0));
        this.bjyVideoPlayer.addOnFirstFrameListener(() -> VideoListActivity.initView$lambda$2(this));
        this.getBinding().recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(this){
            final /* synthetic */ VideoListActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrollStateChanged(recyclerView, newState);
                if (newState == 0) {
                    VideoListActivity.play$default(this.this$0, false, 1, null);
                }
            }

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                super.onScrolled(recyclerView, dx, dy);
                VideoListActivity.access$setDownScroll$p(this.this$0, dy < 0);
            }
        });
        this.getVideoView().setComponentEventListener((arg_0, arg_1) -> VideoListActivity.initView$lambda$3(this, arg_0, arg_1));
        if (this.currentPosition != -1) {
            this.getBinding().recyclerView.scrollToPosition(this.currentPosition);
            this.getBinding().recyclerView.post(() -> VideoListActivity.initView$lambda$4(this));
        }
        this.getAdapter().setNewData(this.videoInfoModelList);
        this.getBinding().refreshLayout.setOnRefreshListener(arg_0 -> VideoListActivity.initView$lambda$5(this, arg_0));
        this.getBinding().refreshLayout.setOnLoadMoreListener(arg_0 -> VideoListActivity.initView$lambda$6(this, arg_0));
        CallbackManager.getInstance().setOnVideoListCallback(new CallbackManager.OnVideoListCallback(this){
            final /* synthetic */ VideoListActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onDataChange(@NotNull List<VideoInfoModel> videoInfoModelList) {
                Intrinsics.checkNotNullParameter(videoInfoModelList, (String)"videoInfoModelList");
                if (this.this$0.isDestroyed() || this.this$0.isFinishing()) {
                    return;
                }
                VideoListActivity.access$getVideoInfoModelList$p(this.this$0).clear();
                VideoListActivity.access$getVideoInfoModelList$p(this.this$0).addAll((Collection)videoInfoModelList);
                VideoListActivity.access$getAdapter(this.this$0).setNewData(VideoListActivity.access$getVideoInfoModelList$p(this.this$0));
                VideoListActivity.access$setCurrentPosition$p(this.this$0, -1);
                VideoListActivity.access$getBinding((VideoListActivity)this.this$0).recyclerView.post(() -> initView.8.onDataChange$lambda$0(this.this$0));
            }

            public void onLoadNoMoreData() {
                if (this.this$0.isDestroyed() || this.this$0.isFinishing()) {
                    return;
                }
                VideoListActivity.access$getBinding((VideoListActivity)this.this$0).refreshLayout.setNoMoreData(true);
            }

            private static final void onDataChange$lambda$0(VideoListActivity this$0) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                VideoListActivity.access$play(this$0, true);
            }
        });
    }

    @Override
    protected int getScreenOrientationAllow() {
        return 7;
    }

    @Override
    protected boolean supportWifiAnim() {
        return false;
    }

    private final void play(boolean forcePlay) {
        View view = this.getSnapHelper().findSnapView((RecyclerView.LayoutManager)this.getLayoutManager());
        if (view == null) {
            return;
        }
        View snapView = view;
        int position = this.getBinding().recyclerView.getChildAdapterPosition(snapView);
        if (!forcePlay && this.currentPosition == position) {
            return;
        }
        this.currentPosition = position;
        if (this.bjyVideoPlayer.isPlaying()) {
            this.bjyVideoPlayer.stop();
        }
        this.getVideoView().reset();
        VideoInfoModel videoInfoModel = this.videoInfoModelList.get(position);
        Intrinsics.checkNotNullExpressionValue((Object)videoInfoModel, (String)"videoInfoModelList[position]");
        VideoInfoModel videoInfoModel2 = videoInfoModel;
        VideoItem videoItem = this.videoItemMap.get(String.valueOf(videoInfoModel2.videoId));
        if (videoItem == null) {
            this.getVideoView().setupOnlineVideoWithId(videoInfoModel2.videoId, videoInfoModel2.token);
        } else {
            this.getVideoView().setupOnlineVideoWithVideoItem(videoItem);
        }
        UtilsKt.removeViewFromParent((View)((View)this.getVideoView()));
        RecyclerView.ViewHolder viewHolder = this.getBinding().recyclerView.getChildViewHolder(snapView);
        Intrinsics.checkNotNull((Object)viewHolder, (String)"null cannot be cast to non-null type com.baijiayun.videoplayer.ui.videoplayer.adapter.VideoViewHolder");
        VideoViewHolder viewHolder2 = (VideoViewHolder)viewHolder;
        viewHolder2.getVideoContainer().addView((View)this.getVideoView(), (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        if (this.videoInfoModelList.size() <= 1) {
            return;
        }
        int nextPosition = 1;
        if (this.currentPosition != 0 && this.currentPosition != this.videoInfoModelList.size() - 1) {
            nextPosition = !this.isDownScroll ? this.currentPosition + 1 : this.currentPosition - 1;
        }
        VideoInfoModel videoInfoModel3 = this.videoInfoModelList.get(nextPosition);
        Intrinsics.checkNotNullExpressionValue((Object)videoInfoModel3, (String)"videoInfoModelList[nextPosition]");
        this.preloadNextItem(videoInfoModel3);
    }

    static /* synthetic */ void play$default(VideoListActivity videoListActivity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        videoListActivity.play(bl);
    }

    private final void preloadNextItem(VideoInfoModel videoInfoModel) {
        if (this.videoItemMap.get(String.valueOf(videoInfoModel.videoId)) != null) {
            return;
        }
        this.loadVideoInfoDisposable = PlayerDataLoader.getInstance((Context)((Context)this)).getLoadVideoInfoObservable(videoInfoModel.videoId, videoInfoModel.token, "", true).subscribe(arg_0 -> VideoListActivity.preloadNextItem$lambda$7((Function1)new Function1<VideoItem, Unit>(this){
            final /* synthetic */ VideoListActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(VideoItem it) {
                Map map = VideoListActivity.access$getVideoItemMap$p(this.this$0);
                String string2 = String.valueOf(it.videoId);
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                map.put(string2, it);
            }
        }, arg_0));
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        RxUtils.Companion.dispose(this.disposableOfLoadVideoInfo);
        RxUtils.Companion.dispose(this.loadVideoInfoDisposable);
        this.getVideoView().onDestroy();
        this._binding = null;
    }

    private static final void initView$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void initView$lambda$2$lambda$1(VideoListActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        View view = this$0.getSnapHelper().findSnapView((RecyclerView.LayoutManager)this$0.getLayoutManager());
        if (view == null) {
            return;
        }
        View snapView = view;
        RecyclerView.ViewHolder viewHolder = this$0.getBinding().recyclerView.getChildViewHolder(snapView);
        Intrinsics.checkNotNull((Object)viewHolder, (String)"null cannot be cast to non-null type com.baijiayun.videoplayer.ui.videoplayer.adapter.VideoViewHolder");
        VideoViewHolder viewHolder2 = (VideoViewHolder)viewHolder;
        viewHolder2.setCoverVisibility(8);
    }

    private static final void initView$lambda$2(VideoListActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getBinding().recyclerView.post(() -> VideoListActivity.initView$lambda$2$lambda$1(this$0));
    }

    private static final void initView$lambda$3(VideoListActivity this$0, int eventCode, Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (eventCode == -80007) {
            this$0.finish();
        }
    }

    private static final void initView$lambda$4(VideoListActivity this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.play(true);
    }

    private static final void initView$lambda$5(VideoListActivity this$0, RefreshLayout it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getBinding().refreshLayout.setNoMoreData(false);
        CallbackManager.OnVideoListRefreshListener onVideoListRefreshListener = CallbackManager.getInstance().getOnVideoListRefreshListener();
        if (onVideoListRefreshListener != null) {
            onVideoListRefreshListener.onRefresh();
        }
        this$0.getBinding().refreshLayout.finishRefresh();
    }

    private static final void initView$lambda$6(VideoListActivity this$0, RefreshLayout it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CallbackManager.OnVideoListRefreshListener onVideoListRefreshListener = CallbackManager.getInstance().getOnVideoListRefreshListener();
        if (onVideoListRefreshListener != null) {
            onVideoListRefreshListener.onLoadMore();
        }
        this$0.getBinding().refreshLayout.finishLoadMore();
    }

    private static final void preloadNextItem$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ HashMap access$getVideoItemMap$p(VideoListActivity $this) {
        return $this.videoItemMap;
    }

    public static final /* synthetic */ void access$setDownScroll$p(VideoListActivity $this, boolean bl) {
        $this.isDownScroll = bl;
    }

    public static final /* synthetic */ ArrayList access$getVideoInfoModelList$p(VideoListActivity $this) {
        return $this.videoInfoModelList;
    }

    public static final /* synthetic */ VideoAdapter access$getAdapter(VideoListActivity $this) {
        return $this.getAdapter();
    }

    public static final /* synthetic */ void access$setCurrentPosition$p(VideoListActivity $this, int n) {
        $this.currentPosition = n;
    }

    public static final /* synthetic */ BjyPbActivityVideoListBinding access$getBinding(VideoListActivity $this) {
        return $this.getBinding();
    }

    public static final /* synthetic */ void access$play(VideoListActivity $this, boolean forcePlay) {
        $this.play(forcePlay);
    }
}

