/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.baijiayun.videoplayer.ui.bean.NetworkState;

public class NetworkUtils {
    public static NetworkState getNetworkState(Context context) {
        NetworkInfo.State state;
        ConnectivityManager connManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (null == connManager) {
            return NetworkState.NETWORK_STATE_NONE;
        }
        NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return NetworkState.NETWORK_STATE_NONE;
        }
        NetworkInfo.State networkInfoState = networkInfo.getState();
        if (networkInfoState == NetworkInfo.State.CONNECTING) {
            return NetworkState.NETWORK_STATE_CONNECTING;
        }
        if (!networkInfo.isAvailable()) {
            return NetworkState.NETWORK_STATE_NONE;
        }
        NetworkInfo wifiInfo = connManager.getNetworkInfo(1);
        if (null != wifiInfo && null != (state = wifiInfo.getState()) && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
            return NetworkState.NETWORK_STATE_WIFI;
        }
        return NetworkState.NETWORK_STATE_4G;
    }

    public static boolean isMobile(NetworkState networkState) {
        return networkState.ordinal() > NetworkState.NETWORK_STATE_WIFI.ordinal();
    }

    public static boolean isNetConnected(Context context) {
        NetworkInfo info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected()) {
            return info.getState() == NetworkInfo.State.CONNECTED;
        }
        return false;
    }

    public static synchronized boolean isWifiConnected(Context context) {
        int networkInfoType;
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && ((networkInfoType = networkInfo.getType()) == 1 || networkInfoType == 9)) {
            return networkInfo.isConnected();
        }
        return false;
    }
}

