/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.playback.adapters;

import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.ref.WeakReference;

public class RightAlignItemDecoration
extends RecyclerView.ItemDecoration {
    private WeakReference<RecyclerView> recyclerViewRef;
    private boolean isLayoutRequested = false;
    private int lastWidth = 0;

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        LinearLayoutManager layoutManager2;
        super.getItemOffsets(outRect, view, parent, state);
        if (parent.getLayoutManager() instanceof LinearLayoutManager && (layoutManager2 = (LinearLayoutManager)parent.getLayoutManager()).getOrientation() == 1) {
            int recyclerViewWidth;
            if (this.recyclerViewRef == null || this.recyclerViewRef.get() != parent) {
                this.recyclerViewRef = new WeakReference<RecyclerView>(parent);
                this.resetDecoration();
            }
            if (!((recyclerViewWidth = parent.getWidth()) <= 0 || recyclerViewWidth == this.lastWidth && this.isLayoutRequested)) {
                this.lastWidth = recyclerViewWidth;
                this.isLayoutRequested = true;
                parent.post(() -> {
                    if (this.recyclerViewRef.get() != null) {
                        ((RecyclerView)this.recyclerViewRef.get()).requestLayout();
                        ((RecyclerView)this.recyclerViewRef.get()).invalidateItemDecorations();
                    }
                });
            }
            if (recyclerViewWidth > 0) {
                view.measure(0, 0);
                int itemWidth = view.getMeasuredWidth();
                int rightOffset = recyclerViewWidth - itemWidth;
                if (rightOffset > 0) {
                    outRect.left = rightOffset;
                }
            }
        }
    }

    private void resetDecoration() {
        this.lastWidth = 0;
        this.isLayoutRequested = false;
    }
}

