/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.ui.listener;

import androidx.core.util.Consumer;
import androidx.fragment.app.DialogFragment;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.player.PlayerStatus;
import com.baijiayun.videoplayer.ui.bean.DragControllerModel;
import com.baijiayun.videoplayer.ui.bean.SignModel;
import com.baijiayun.videoplayer.ui.bean.VideoInfoModel;
import java.util.List;

public class CallbackManager {
    private Consumer<SignModel> signModelConsumer;
    private ShareListener shareListener;
    private VisitorListener visitorListener;
    private Consumer<DragControllerModel> dragConsumer;
    private OuterPlayerListener outerPlayerListener;
    private ExternalAlbumListener externalAlbumListener;
    private OnVideoListRefreshListener onVideoListRefreshListener;
    private OnVideoListCallback onVideoListCallback;

    private CallbackManager() {
    }

    public static CallbackManager getInstance() {
        return CallbackManagerHolder.INSTANCE;
    }

    public void setSignListener(Consumer<SignModel> consumer) {
        this.signModelConsumer = consumer;
    }

    public Consumer<SignModel> getSignModelConsumer() {
        return this.signModelConsumer;
    }

    public void setShareListener(ShareListener shareListener) {
        this.shareListener = shareListener;
    }

    public ShareListener getShareListener() {
        return this.shareListener;
    }

    public VisitorListener getVisitorListener() {
        return this.visitorListener;
    }

    public void setVisitorListener(VisitorListener visitorListener) {
        this.visitorListener = visitorListener;
    }

    public Consumer<DragControllerModel> getDragConsumer() {
        return this.dragConsumer;
    }

    public void setDragListener(Consumer<DragControllerModel> runnable) {
        this.dragConsumer = runnable;
    }

    public void setOuterPlayerListener(OuterPlayerListener outerPlayerListener) {
        this.outerPlayerListener = outerPlayerListener;
    }

    public OuterPlayerListener getOuterPlayerListener() {
        return this.outerPlayerListener;
    }

    public void setExternalAlbumListener(ExternalAlbumListener externalAlbumListener) {
        this.externalAlbumListener = externalAlbumListener;
    }

    public ExternalAlbumListener getExternalAlbumListener() {
        return this.externalAlbumListener;
    }

    public OnVideoListRefreshListener getOnVideoListRefreshListener() {
        return this.onVideoListRefreshListener;
    }

    public void setOnVideoListRefreshListener(OnVideoListRefreshListener onVideoListRefreshListener) {
        this.onVideoListRefreshListener = onVideoListRefreshListener;
    }

    public OnVideoListCallback getOnVideoListCallback() {
        return this.onVideoListCallback;
    }

    public void setOnVideoListCallback(OnVideoListCallback onVideoListCallback) {
        this.onVideoListCallback = onVideoListCallback;
    }

    public void clearListener() {
        this.signModelConsumer = null;
        this.shareListener = null;
        this.visitorListener = null;
        this.dragConsumer = null;
        this.outerPlayerListener = null;
        this.externalAlbumListener = null;
    }

    private static class CallbackManagerHolder {
        private static final CallbackManager INSTANCE = new CallbackManager();

        private CallbackManagerHolder() {
        }
    }

    public static interface ShareListener {
        public void onShareClicked(String var1);
    }

    public static interface VisitorListener {
        public void onPositiveClick(DialogFragment var1, IBJYVideoPlayer var2);

        public void onNavigateClick(DialogFragment var1, IBJYVideoPlayer var2);
    }

    public static interface OuterPlayerListener {
        public void onPlayerStatusChanged(PlayerStatus var1);

        public void onPlayTimeChanged(int var1, int var2);

        public void onPlayerError(LPError var1);
    }

    public static interface ExternalAlbumListener {
        public void onExternalAlbumClick();
    }

    public static interface OnVideoListRefreshListener {
        public void onRefresh();

        public void onLoadMore();
    }

    public static interface OnVideoListCallback {
        public void onDataChange(List<VideoInfoModel> var1);

        public void onLoadNoMoreData();
    }
}

