/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.subtitle;

import android.annotation.TargetApi;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import androidx.annotation.Nullable;
import com.baijiayun.videoplayer.subtitle.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class CaptionStyleCompat {
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int USE_TRACK_COLOR_SETTINGS = 1;
    public static final CaptionStyleCompat DEFAULT = new CaptionStyleCompat(-1, 0, 0, 2, -16777216, null);
    public final int foregroundColor;
    public final int backgroundColor;
    public final int windowColor;
    public final int edgeType;
    public final int edgeColor;
    @Nullable
    public final Typeface typeface;

    @TargetApi(value=19)
    public static CaptionStyleCompat createFromCaptionStyle(CaptioningManager.CaptionStyle captionStyle) {
        if (Util.SDK_INT >= 21) {
            return CaptionStyleCompat.createFromCaptionStyleV21(captionStyle);
        }
        return CaptionStyleCompat.createFromCaptionStyleV19(captionStyle);
    }

    public CaptionStyleCompat(int n2, int n3, int n4, int n5, int n6, @Nullable Typeface typeface) {
        this.foregroundColor = n2;
        this.backgroundColor = n3;
        this.windowColor = n4;
        this.edgeType = n5;
        this.edgeColor = n6;
        this.typeface = typeface;
    }

    @TargetApi(value=19)
    private static CaptionStyleCompat createFromCaptionStyleV19(CaptioningManager.CaptionStyle captionStyle) {
        CaptioningManager.CaptionStyle captionStyle2 = captionStyle;
        int n2 = captionStyle2.foregroundColor;
        int n3 = captionStyle2.backgroundColor;
        int n4 = captionStyle2.edgeType;
        int n5 = captionStyle2.edgeColor;
        Typeface typeface = captionStyle2.getTypeface();
        return new CaptionStyleCompat(n2, n3, 0, n4, n5, typeface);
    }

    @TargetApi(value=21)
    private static CaptionStyleCompat createFromCaptionStyleV21(CaptioningManager.CaptionStyle captionStyle) {
        CaptionStyleCompat captionStyleCompat;
        int n2 = captionStyle.hasForegroundColor() ? captionStyle.foregroundColor : CaptionStyleCompat.DEFAULT.foregroundColor;
        int n3 = captionStyle.hasBackgroundColor() ? captionStyle.backgroundColor : CaptionStyleCompat.DEFAULT.backgroundColor;
        int n4 = captionStyle.hasWindowColor() ? captionStyle.windowColor : CaptionStyleCompat.DEFAULT.windowColor;
        int n5 = captionStyle.hasEdgeType() ? captionStyle.edgeType : CaptionStyleCompat.DEFAULT.edgeType;
        int n6 = captionStyle.hasEdgeColor() ? captionStyle.edgeColor : CaptionStyleCompat.DEFAULT.edgeColor;
        CaptionStyleCompat captionStyleCompat2 = captionStyleCompat;
        captionStyle = captionStyle.getTypeface();
        captionStyleCompat2(n2, n3, n4, n5, n6, (Typeface)captionStyle);
        return captionStyleCompat2;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EdgeType {
    }
}

