/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import com.baijiayun.constant.VideoDefinition;
import com.baijiayun.videoplayer.BJYVideoPlayerImpl;
import com.baijiayun.videoplayer.BJYVideoPlayerMixedImpl;
import com.baijiayun.videoplayer.IBJYVideoPlayer;
import com.baijiayun.videoplayer.widget.BJYPlayerView;
import java.util.List;

public class VideoPlayerFactory {
    public static BJYPlayerView createPlayerView(Context context) {
        return new BJYPlayerView(context);
    }

    public static IBJYVideoPlayer createDefaultVideoPlayer() {
        return new BJYVideoPlayerImpl(null);
    }

    public static class Builder {
        private boolean supportBackgroundAudio = false;
        private boolean supportLooping = false;
        private boolean supportBreakPointPlay = false;
        private Lifecycle lifecycle;
        private List<VideoDefinition> preferredDefinitionList;
        private Context mContext;
        private String userName;
        private String userIdentity;
        private boolean isMixedPlayback = false;
        private boolean enableStatisticsReport = true;

        @NonNull
        private static <T> T checkNotNull(T t2, String string) {
            if (t2 != null) {
                return t2;
            }
            throw new NullPointerException(string);
        }

        public Builder setSupportBackgroundAudio(boolean bl) {
            this.supportBackgroundAudio = bl;
            return this;
        }

        public Builder setLifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public Builder setSupportLooping(boolean bl) {
            this.supportLooping = bl;
            return this;
        }

        public Builder setSupportBreakPointPlay(boolean bl) {
            this.supportBreakPointPlay = bl;
            return this;
        }

        public Builder setPreferredDefinitions(List<VideoDefinition> list) {
            this.preferredDefinitionList = list;
            return this;
        }

        public Builder setUserInfo(String string, String string2) {
            this.userName = string;
            this.userIdentity = string2;
            return this;
        }

        public Builder setMixedPlayback(boolean bl) {
            this.isMixedPlayback = bl;
            return this;
        }

        public Builder setContext(Context context) {
            this.mContext = context.getApplicationContext();
            return this;
        }

        public Builder setStatisticReportEnable(boolean bl) {
            this.enableStatisticsReport = bl;
            return this;
        }

        public IBJYVideoPlayer build() {
            Object object;
            BJYVideoPlayerImpl bJYVideoPlayerImpl;
            if (((Builder)((Object)string)).isMixedPlayback) {
                BJYVideoPlayerMixedImpl bJYVideoPlayerMixedImpl;
                bJYVideoPlayerImpl = bJYVideoPlayerMixedImpl;
                bJYVideoPlayerMixedImpl = new BJYVideoPlayerMixedImpl(Builder.checkNotNull(((Builder)((Object)string)).mContext, "context == null, please call setContext first."));
            } else {
                BJYVideoPlayerImpl bJYVideoPlayerImpl2;
                bJYVideoPlayerImpl = bJYVideoPlayerImpl2;
                Builder builder = string;
                object = Builder.checkNotNull(builder.mContext, "context == null, please call setContext first.");
                bJYVideoPlayerImpl2 = new BJYVideoPlayerImpl((Context)object, builder.enableStatisticsReport);
            }
            bJYVideoPlayerImpl.supportBackgroundAudio(((Builder)((Object)string)).supportBackgroundAudio);
            bJYVideoPlayerImpl.supportLooping(((Builder)((Object)string)).supportLooping);
            object = ((Builder)((Object)string)).preferredDefinitionList;
            if (object != null) {
                bJYVideoPlayerImpl.setPreferredDefinitions((Iterable<VideoDefinition>)object);
            }
            if ((object = ((Builder)((Object)string)).lifecycle) != null) {
                object.addObserver((LifecycleObserver)bJYVideoPlayerImpl);
            }
            if (((Builder)((Object)string)).supportBreakPointPlay) {
                bJYVideoPlayerImpl.enableBreakPointMemory(Builder.checkNotNull(((Builder)((Object)string)).mContext, "context == null"));
            }
            if (!TextUtils.isEmpty((CharSequence)((Builder)((Object)string)).userName) || !TextUtils.isEmpty((CharSequence)((Builder)((Object)string)).userIdentity)) {
                Builder builder = string;
                String string = builder.userName;
                bJYVideoPlayerImpl.setUserInfo(string, builder.userIdentity);
            }
            return bJYVideoPlayerImpl;
        }
    }
}

