/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.playback.ppt;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.bjyutils.kt.UtilsKt;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.livebase.context.LPError;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.baijiayun.livebase.widgets.view.photoview.OnViewTapListener;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.playback.ppt.WhiteboardView;
import com.baijiayun.playback.ppt.animppt.LPAnimChangeModel;
import com.baijiayun.playback.ppt.animppt.LPAnimPPTRouterCallbackListener;
import com.baijiayun.videoplayer.a;
import com.baijiayun.videoplayer.b0;
import com.baijiayun.videoplayer.f;
import com.baijiayun.videoplayer.s0;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PPTView
extends RelativeLayout
implements LPAnimPPTRouterCallbackListener {
    private static final String TAG = PPTView.class.getSimpleName();
    private List<b0.a> mDocList = new ArrayList<b0.a>();
    private final Context context;
    private WhiteboardView staticPPT;
    private a animPPT;
    private f blackImageWindow;
    private PBRoom pbRoom;
    private LPAnimChangeModel lpAnimChangeModel = new LPAnimChangeModel();
    private LPAnimChangeModel skippedChangeModel;
    private LPAnimChangeModel lastPageChangeModel;
    private boolean isLoadFinish;
    private OnViewTapListener onViewTapListener;
    private OnPPTErrorListener onPPTErrorListener;
    private GestureDetector.OnDoubleTapListener onDoubleTapListener;
    private boolean isDoubleTapScaleEnable = true;
    public List<b0.a> docList = new ArrayList<b0.a>();
    private boolean isAnimPPTEnable = true;
    private s0 pptViewType = s0.a;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private float currentScrollTop;
    private boolean isPPTAttached;
    private OnPPTCallback callback;
    private boolean isSizeChange;
    private int imageWidth;
    private int imageHeight;

    public PPTView(Context context) {
        this(context, null);
    }

    public PPTView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PPTView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.context = context;
    }

    private void initStaticPPTView(PBRoom pBRoom) {
        WhiteboardView whiteboardView;
        WhiteboardView whiteboardView2;
        PPTView pPTView = this;
        WhiteboardView whiteboardView3 = whiteboardView2 = whiteboardView;
        whiteboardView3(this.context);
        this.staticPPT = whiteboardView3;
        whiteboardView.attachPBRoom(pBRoom);
        pPTView.addView((View)pPTView.staticPPT, -1, -1);
        pPTView.staticPPT.setOnViewTapListener(this.onViewTapListener);
        pBRoom = pPTView.onDoubleTapListener;
        if (pBRoom != null) {
            this.staticPPT.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)pBRoom);
        }
        PPTView pPTView2 = this;
        pPTView2.staticPPT.setDoubleTapScaleEnable(this.isDoubleTapScaleEnable);
        pPTView2.staticPPT.setDocList(this.mDocList);
    }

    private void initAnimPPTView(PBRoom pBRoom) {
        a a2;
        a a3;
        PPTView pPTView = this;
        a a4 = a3 = a2;
        a4(this);
        this.animPPT = a4;
        a2.a(pBRoom);
        pPTView.animPPT.a(this.onViewTapListener);
        pBRoom = pPTView.onDoubleTapListener;
        if (pBRoom != null) {
            this.animPPT.a((GestureDetector.OnDoubleTapListener)pBRoom);
        }
        this.animPPT.a(this.mDocList);
    }

    private void initSmallCourseBlackboardView(PBRoom pBRoom) {
        if (pBRoom.isSmallCourseSignalPlayback()) {
            f f2;
            f f3;
            PPTView pPTView = this;
            f f4 = f3 = f2;
            f4(this.context);
            this.blackImageWindow = f4;
            f2.a(pBRoom);
            pPTView.blackImageWindow.a(this.mDocList);
            pPTView.addView(pPTView.blackImageWindow.a(), -1, -1);
        }
    }

    private void setBlackImageWindowVisibility(int n2) {
        Object object;
        f f2 = ((PPTView)object).blackImageWindow;
        if (f2 == null) {
            return;
        }
        f2.a().setVisibility(n2);
        if (((PPTView)object).isAnimPPT()) {
            object = ((PPTView)object).animPPT;
            if (object != null) {
                n2 = n2 == 0 ? 4 : 0;
                ((a)object).a(n2);
            }
        } else {
            object = ((PPTView)object).staticPPT;
            if (object != null) {
                n2 = n2 == 0 ? 4 : 0;
                object.setVisibility(n2);
            }
        }
    }

    private boolean isAnimPPT() {
        if (this.didRoomContainsH5PPT()) {
            return true;
        }
        if (BJYPlayerSDK.DISABLE_ANIM_PPT) {
            return false;
        }
        return this.isAnimPPTEnable && this.didRoomContainsAnimPPT();
    }

    private boolean didRoomContainsAnimPPT() {
        List<b0.a> list = ((PPTView)((Object)iterator)).docList;
        if (list == null || list.isEmpty()) {
            ((PPTView)((Object)iterator)).docList = ((PPTView)((Object)iterator)).pbRoom.getDocListVM().getDocList();
        }
        if ((list = ((PPTView)((Object)iterator)).docList) != null && !list.isEmpty()) {
            Iterator<b0.a> iterator = ((PPTView)((Object)iterator)).docList.iterator();
            while (iterator.hasNext()) {
                if (TextUtils.isEmpty((CharSequence)((b0.a)iterator.next()).i)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void initDocList(List<b0.a> list) {
        this.mDocList = list;
        this.attachPPT();
    }

    private void updatePage(LPAnimChangeModel lPAnimChangeModel, boolean bl) {
        this.setBlackImageWindowVisibility(4);
        this.lastPageChangeModel = lPAnimChangeModel;
        if ("0".equals(lPAnimChangeModel.docId) && this.blackImageWindow != null) {
            PPTView pPTView = this;
            pPTView.setBlackImageWindowVisibility(0);
            pPTView.blackImageWindow.b().updatePage(lPAnimChangeModel.absoluteIndex, bl);
            return;
        }
        if (this.isAnimPPT()) {
            if (!this.isLoadFinish) {
                this.skippedChangeModel = lPAnimChangeModel;
                return;
            }
            this.animPPT.b(lPAnimChangeModel);
        } else {
            int n2 = lPAnimChangeModel.absoluteIndex;
            if (n2 >= this.mDocList.size()) {
                this.skippedChangeModel = lPAnimChangeModel;
                if (!this.mDocList.isEmpty()) {
                    AliYunLogHelper.getInstance().addErrorLog("PPTView updatePage \u4e0b\u6807\u8d8a\u754c index=" + n2 + ", mDocList.size()=" + this.mDocList.size());
                }
                return;
            }
            this.staticPPT.updatePage(n2, bl);
        }
    }

    private void clearShape() {
        this.animPPT.c().onShapeClear();
    }

    private void attachPPT() {
        Object object = ((PPTView)((Object)onPPTCallback)).isAnimPPT() ? s0.c : s0.b;
        PPTView pPTView = onPPTCallback;
        List<b0.a> list = pPTView.pbRoom.getDocListVM().getDocList();
        pPTView.mDocList = list;
        if (object != pPTView.pptViewType) {
            ((PPTView)((Object)onPPTCallback)).destroyView();
            ((PPTView)((Object)onPPTCallback)).pptViewType = object;
            if (object == s0.b) {
                PPTView pPTView2 = onPPTCallback;
                pPTView2.initStaticPPTView(pPTView2.pbRoom);
            } else {
                PPTView pPTView3 = onPPTCallback;
                pPTView3.initAnimPPTView(pPTView3.pbRoom);
            }
            PPTView pPTView4 = onPPTCallback;
            pPTView4.initSmallCourseBlackboardView(pPTView4.pbRoom);
        } else {
            object = ((PPTView)((Object)onPPTCallback)).blackImageWindow;
            if (object != null) {
                ((f)object).a(list);
            }
            if (((PPTView)((Object)onPPTCallback)).pptViewType == s0.b) {
                ((PPTView)((Object)onPPTCallback)).staticPPT.setDocList(((PPTView)((Object)onPPTCallback)).mDocList);
            } else {
                ((PPTView)((Object)onPPTCallback)).animPPT.a(((PPTView)((Object)onPPTCallback)).mDocList);
            }
        }
        object = ((PPTView)((Object)onPPTCallback)).lastPageChangeModel;
        if (object != null) {
            ((PPTView)((Object)onPPTCallback)).updatePage((LPAnimChangeModel)object, false);
        }
        ((PPTView)((Object)onPPTCallback)).isPPTAttached = true;
        OnPPTCallback onPPTCallback = ((PPTView)((Object)onPPTCallback)).callback;
        if (onPPTCallback != null) {
            onPPTCallback.attached();
        }
    }

    private boolean didRoomContainsH5PPT() {
        List<b0.a> list = this.docList;
        if (list == null || list.isEmpty()) {
            this.docList = this.pbRoom.getDocListVM().getDocList();
        }
        if ((list = this.docList) != null && !list.isEmpty()) {
            for (int i2 = 0; i2 < this.docList.size(); i2 += Math.max(1, this.docList.get((int)i2).k)) {
                if (!this.docList.get((int)i2).l) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void requestAllShapes(LPAnimChangeModel lPAnimChangeModel) {
        PPTView pPTView = this;
        LPAnimChangeModel lPAnimChangeModel2 = lPAnimChangeModel;
        int n2 = UtilsKt.getDp((int)lPAnimChangeModel2.width);
        int n3 = UtilsKt.getDp((int)lPAnimChangeModel2.height);
        pPTView.animPPT.c().setCurrentWidth(n2);
        pPTView.animPPT.c().setCurrentHeight(n3);
        pPTView.animPPT.c().setIdentity(lPAnimChangeModel);
        pPTView.animPPT.c().requestPageAllShapes(lPAnimChangeModel);
        pPTView.animPPT.c().resetDisplayRec(n2, n3);
    }

    private void recoverSkippedPageChange() {
        LPAnimChangeModel lPAnimChangeModel = this.skippedChangeModel;
        if (lPAnimChangeModel != null) {
            this.updatePage(lPAnimChangeModel, false);
            this.skippedChangeModel = null;
        }
    }

    private void destroyView() {
        Object object = ((PPTView)((Object)onPPTCallback)).staticPPT;
        if (object != null) {
            ((WhiteboardView)object).destroy();
        }
        if ((object = ((PPTView)((Object)onPPTCallback)).animPPT) != null) {
            ((a)object).b();
        }
        PPTView pPTView = onPPTCallback;
        pPTView.removeAllViews();
        pPTView.isPPTAttached = false;
        OnPPTCallback onPPTCallback = pPTView.callback;
        if (onPPTCallback != null) {
            onPPTCallback.destroy();
        }
    }

    public void attachRoom(PBRoom pBRoom) {
        PPTView pPTView = this;
        pPTView.pbRoom = pBRoom;
        pPTView.compositeDisposable.add(pBRoom.getDocListVM().getObservableOfDocListChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(this::initDocList));
        pPTView.compositeDisposable.add(pBRoom.getDocListVM().getObservableOfDocPageIndex().observeOn(AndroidSchedulers.mainThread()).subscribe(lPAnimChangeModel -> this.updatePage((LPAnimChangeModel)lPAnimChangeModel, false)));
        pPTView.compositeDisposable.add(pBRoom.getDocListVM().getObservableOfDocUpdate().distinctUntilChanged().observeOn(AndroidSchedulers.mainThread()).subscribe(f2 -> {
            ((PPTView)((Object)f3)).currentScrollTop = f2.floatValue();
            f f3 = ((PPTView)((Object)f3)).blackImageWindow;
            if (f3 != null) {
                f3.a(f2.floatValue());
            }
        }));
    }

    public void sizeChange() {
        a a2;
        if (this.isAnimPPT() && (a2 = this.animPPT) != null) {
            this.isSizeChange = true;
            a2.i();
        }
    }

    public void setZoomable(boolean bl) {
        WhiteboardView whiteboardView = ((PPTView)this).staticPPT;
        if (whiteboardView != null) {
            whiteboardView.setZoomable(bl);
        }
        if ((this = ((PPTView)this).animPPT) != null) {
            ((a)this).a(bl);
        }
    }

    @Override
    public void onLoadFinish() {
        this.isLoadFinish = true;
        this.recoverSkippedPageChange();
    }

    public void setAnimPPTEnable(boolean bl) {
        if (this.didRoomContainsH5PPT()) {
            return;
        }
        this.isAnimPPTEnable = bl;
        this.attachPPT();
    }

    @Override
    public void onAnimPageChangeStart(boolean bl) {
        if (!bl) {
            this.clearShape();
        }
    }

    @Override
    public void onAnimPageChangeFinish(LPAnimChangeModel lPAnimChangeModel) {
        int n2 = lPAnimChangeModel.width > 0 && lPAnimChangeModel.height > 0 ? 1 : 0;
        boolean bl = !lPAnimChangeModel.isStepChange || ((PPTView)((Object)onPPTErrorListener)).animPPT.c().getDrawable() == null || !((PPTView)((Object)onPPTErrorListener)).animPPT.f();
        if (n2 != 0 && bl) {
            PPTView pPTView = onPPTErrorListener;
            LPAnimChangeModel lPAnimChangeModel2 = lPAnimChangeModel;
            lPAnimChangeModel2.width = (int)((float)lPAnimChangeModel2.width / ((PPTView)((Object)onPPTErrorListener)).animPPT.d());
            lPAnimChangeModel2.height = n2 = (int)((float)lPAnimChangeModel2.height / ((PPTView)((Object)onPPTErrorListener)).animPPT.d());
            ((PPTView)((Object)onPPTErrorListener)).lpAnimChangeModel = lPAnimChangeModel2;
            pPTView.imageWidth = lPAnimChangeModel.width;
            pPTView.imageHeight = n2;
            pPTView.clearShape();
            pPTView.requestAllShapes(pPTView.lpAnimChangeModel);
            pPTView.animPPT.a(UtilsKt.getDp((int)((PPTView)((Object)onPPTErrorListener)).imageWidth), UtilsKt.getDp((int)((PPTView)((Object)onPPTErrorListener)).imageHeight));
            pPTView.animPPT.a(lPAnimChangeModel);
        }
        PPTView pPTView = onPPTErrorListener;
        pPTView.recoverSkippedPageChange();
        OnPPTErrorListener onPPTErrorListener = pPTView.onPPTErrorListener;
        if (onPPTErrorListener != null) {
            onPPTErrorListener.onAnimPPTLoadFinish();
        }
    }

    @Override
    public void onAnimPageSize(int n2, int n3) {
        if (n2 > 0 && n3 > 0 && this.isSizeChange) {
            PPTView pPTView = this;
            this.isSizeChange = false;
            float f2 = (float)n2 / this.animPPT.d();
            float f3 = (float)n3 / this.animPPT.d();
            pPTView.lpAnimChangeModel.width = Math.round(f2);
            pPTView.lpAnimChangeModel.height = Math.round(f3);
            LPAnimChangeModel lPAnimChangeModel = pPTView.lpAnimChangeModel;
            pPTView.imageWidth = lPAnimChangeModel.width;
            pPTView.imageHeight = lPAnimChangeModel.height;
            pPTView.clearShape();
            pPTView.requestAllShapes(pPTView.lpAnimChangeModel);
            pPTView.animPPT.c().post(() -> {
                PPTView pPTView = this;
                pPTView.animPPT.a(UtilsKt.getDp((int)this.imageWidth), UtilsKt.getDp((int)this.imageHeight));
                pPTView.animPPT.j();
            });
        }
    }

    @Override
    public void onAnimMaxPageChanged(int n2, boolean bl, boolean bl2) {
    }

    @Override
    public void onAnimPageLoadStart() {
        OnPPTErrorListener onPPTErrorListener = ((PPTView)((Object)onPPTErrorListener)).onPPTErrorListener;
        if (onPPTErrorListener != null) {
            onPPTErrorListener.onAnimPPTLoadStart();
        }
    }

    public void setPPTErrorListener(OnPPTErrorListener onPPTErrorListener) {
        this.onPPTErrorListener = onPPTErrorListener;
    }

    @Override
    public void onAnimPageLoadError(LPError lPError) {
        if (lPError.getCode() != -2007) {
            ((PPTView)this).setAnimPPTEnable(false);
        }
        if ((this = ((PPTView)this).onPPTErrorListener) != null) {
            LPError lPError2 = lPError;
            int n2 = lPError2.getCode();
            this.onAnimPPTLoadError(n2, lPError2.getMessage());
        }
        LPLogger.w((String)TAG, (String)("onError:" + lPError.getMessage() + "   errorCode:" + lPError.getCode()));
    }

    public void onMeasure(int n2, int n3) {
        PPTView pPTView = this;
        super.onMeasure(n2, n3);
        if (pPTView.blackImageWindow != null) {
            n3 = View.MeasureSpec.getSize((int)n3);
            n2 = View.MeasureSpec.getSize((int)n2);
            if (n3 != 0 && n2 != 0) {
                int n4 = n3 * 16 / 9;
                if (n2 < n4) {
                    n3 = n2 * 9 / 16;
                } else {
                    n2 = n4;
                }
                PPTView pPTView2 = this;
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)pPTView2.blackImageWindow.a().getLayoutParams();
                layoutParams.width = n2;
                layoutParams.height = n3;
                layoutParams.addRule(13);
                pPTView2.blackImageWindow.a().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                pPTView2.blackImageWindow.a(n2, n3 * this.pbRoom.getSmallCourseBlackboardPage());
            } else {
                return;
            }
        }
    }

    public void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        PPTView pPTView = this;
        super.onLayout(bl, n2, n3, n4, n5);
        f f2 = pPTView.blackImageWindow;
        if (f2 != null) {
            f2.a(this.currentScrollTop);
        }
    }

    public void setOnViewTapListener(OnViewTapListener object) {
        this.onViewTapListener = object;
        if (this.isAnimPPT()) {
            object = this.animPPT;
            if (object != null) {
                ((a)object).a(this.onViewTapListener);
            }
        } else {
            object = this.staticPPT;
            if (object != null) {
                object.setOnViewTapListener(this.onViewTapListener);
            }
        }
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        Object object;
        ((PPTView)object).onDoubleTapListener = onDoubleTapListener;
        if (((PPTView)object).isAnimPPT()) {
            object = ((PPTView)object).animPPT;
            if (object != null) {
                ((a)object).a(onDoubleTapListener);
            }
        } else {
            object = ((PPTView)object).staticPPT;
            if (object != null) {
                object.setOnDoubleTapListener(onDoubleTapListener);
            }
        }
    }

    public void setDoubleTapScaleEnable(boolean bl) {
        ((PPTView)((Object)whiteboardView)).isDoubleTapScaleEnable = bl;
        WhiteboardView whiteboardView = ((PPTView)((Object)whiteboardView)).staticPPT;
        if (whiteboardView != null) {
            whiteboardView.setDoubleTapScaleEnable(bl);
        }
    }

    public void setPPTCallback(OnPPTCallback onPPTCallback) {
        this.callback = onPPTCallback;
    }

    public boolean isPPTAttached() {
        return this.isPPTAttached;
    }

    public void destroy() {
        PPTView pPTView = this;
        pPTView.onPPTErrorListener = null;
        pPTView.destroyView();
        pPTView.callback = null;
        pPTView.compositeDisposable.dispose();
    }

    public void release() {
        PPTView pPTView = this;
        pPTView.onPPTErrorListener = null;
        pPTView.destroyView();
        pPTView.callback = null;
        pPTView.compositeDisposable.clear();
    }

    public static interface OnPPTCallback {
        public void attached();

        public void destroy();
    }

    public static interface OnPPTErrorListener {
        public void onAnimPPTLoadError(int var1, String var2);

        public void onAnimPPTLoadFinish();

        public void onAnimPPTLoadStart();
    }
}

