/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.download;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.constant.VideoDefinition;
import com.baijiayun.download.DownloadModel;
import com.baijiayun.download.DownloadTask;
import com.baijiayun.download.DownloadTaskImpl;
import com.baijiayun.download.JsonUtils;
import com.baijiayun.download.OnNetChangeListener;
import com.baijiayun.download.constant.FileType;
import com.baijiayun.download.constant.TaskStatus;
import com.baijiayun.livebase.utils.net.NetUtils;
import com.baijiayun.playback.dataloader.PlayerDataLoader;
import com.baijiayun.videoplayer.bean.CDNInfo;
import com.baijiayun.videoplayer.bean.PlayItem;
import com.baijiayun.videoplayer.bean.VideoItem;
import com.baijiayun.videoplayer.t;
import com.baijiayun.videoplayer.util.VideoDataSourceHelper;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;
import com.baijiayun.videoplayer.w1;
import com.tencent.mmkv.MMKV;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DownloadManager {
    private static volatile DownloadManager instance;
    private static final String MMKV_BAIJIAYUN = "mmkv_baijiayun";
    private List<DownloadTask> taskList;
    private List<DownloadModel> modelList;
    private String targetFolder;
    private b globalInternalListener;
    private boolean isDownloadInfoLoaded = false;
    private ExecutorService defaultThreadPool;
    private Context context;
    private NetChangeReceiver netChangeReceiver;
    private PlayerDataLoader mDataLoader;
    private MMKV kv;
    private List<VideoDefinition> preferredDefinitionList = new ArrayList<VideoDefinition>();
    private OnNetChangeListener onNetChangeListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<DownloadManager> clazz = DownloadManager.class;
        synchronized (DownloadManager.class) {
            if (instance != null) return instance;
            instance = new DownloadManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private DownloadManager(Context context) {
        this.globalInternalListener = new b(null);
        this.taskList = Collections.synchronizedList(new ArrayList());
        this.defaultThreadPool = Executors.newCachedThreadPool();
        JsonUtils.a();
        this.context = context.getApplicationContext();
    }

    private void resumeStatusFromProcessKilled(DownloadModel downloadModel) {
        while (downloadModel != null) {
            if (downloadModel.status == TaskStatus.Downloading) {
                downloadModel.status = TaskStatus.Pause;
                break;
            }
            downloadModel = downloadModel.nextModel;
        }
    }

    private DownloadTask newPlayBackTask(DownloadModel downloadModel) {
        Object object = null;
        Object object2 = this.taskList.iterator();
        while (object2.hasNext()) {
            DownloadTask downloadTask = object2.next();
            if (!downloadTask.getVideoDownloadInfo().equals(downloadModel)) continue;
            object = (DownloadTaskImpl)downloadTask;
            object2 = ((DownloadTaskImpl)object).b;
            while (object2 != null && downloadModel != null) {
                ((DownloadModel)object2).targetFolder = this.targetFolder;
                ((DownloadModel)object2).url = downloadModel.url;
                object2 = ((DownloadModel)object2).nextModel;
                downloadModel = downloadModel.nextModel;
            }
            downloadModel = ((DownloadTaskImpl)object).b;
            object = downloadTask;
            break;
        }
        if (object == null) {
            DownloadTaskImpl downloadTaskImpl;
            object = downloadModel;
            while (object != null) {
                ((DownloadModel)object).targetFolder = this.targetFolder;
                object = ((DownloadModel)object).nextModel;
            }
            object = downloadTaskImpl;
            ((DownloadTaskImpl)object)(downloadModel);
            downloadTaskImpl.a(this.defaultThreadPool);
            this.taskList.add((DownloadTask)object);
        }
        ((DownloadTaskImpl)object).a(this.globalInternalListener);
        this.globalInternalListener.d(downloadModel);
        return object;
    }

    public void loadDownloadInfo(boolean bl) {
        this.loadDownloadInfo("", bl);
    }

    public void loadDownloadInfo() {
        this.loadDownloadInfo(false);
    }

    public void loadDownloadInfo(String string, boolean bl) {
        this.loadDownloadInfo(string, "", bl);
    }

    public void loadDownloadInfo(String object, String string, boolean n2) {
        if (this.isDownloadInfoLoaded && n2 == 0) {
            return;
        }
        this.isDownloadInfoLoaded = true;
        if (!TextUtils.isEmpty((CharSequence)this.targetFolder)) {
            if (TextUtils.isEmpty((CharSequence)object)) {
                object = MMKV_BAIJIAYUN;
            }
            this.mDataLoader = PlayerDataLoader.getInstance(this.context);
            this.kv = !TextUtils.isEmpty((CharSequence)string) ? MMKV.mmkvWithID((String)object, (String)string) : MMKV.mmkvWithID((String)object);
            DownloadManager downloadManager = this;
            downloadManager.taskList.clear();
            downloadManager.modelList = new CopyOnWriteArrayList<DownloadModel>();
            if (downloadManager.kv.allKeys() == null) {
                return;
            }
            for (String string2 : this.kv.allKeys()) {
                if (string2.equals("need_transfer")) continue;
                this.modelList.add(JsonUtils.a(this.kv.getString(string2, ""), DownloadModel.class));
            }
            for (DownloadModel downloadModel : this.modelList) {
                DownloadTaskImpl downloadTaskImpl;
                if (downloadModel.status == TaskStatus.Cancel) continue;
                this.resumeStatusFromProcessKilled(downloadModel);
                DownloadTaskImpl downloadTaskImpl2 = downloadTaskImpl;
                downloadTaskImpl2(downloadModel);
                downloadTaskImpl2.a(this.defaultThreadPool);
                downloadTaskImpl.a(this.globalInternalListener);
                while (downloadModel != null) {
                    if (downloadModel.status != TaskStatus.Finish) {
                        String string2;
                        DownloadModel downloadModel2 = downloadModel;
                        string2 = downloadModel2.targetFolder;
                        downloadModel.downloadLength = new File(string2, downloadModel2.targetName).length();
                    }
                    downloadModel = downloadModel.nextModel;
                }
                this.taskList.add(downloadTaskImpl2);
            }
            return;
        }
        throw new RuntimeException("targetFolder is null");
    }

    public Observable<DownloadTask> newPlaybackDownloadTask(String string, long l2, long l3, String string2, String string3) {
        boolean bl = BJYPlayerSDK.IS_ENCRYPT;
        return this.newPlaybackDownloadTask(string, l2, l3, string2, string3, bl);
    }

    public Observable<DownloadTask> newPlaybackDownloadTask(String object, long l2, long l3, String string, String string2, int n2) {
        String string3 = object;
        boolean bl = BJYPlayerSDK.IS_ENCRYPT;
        object = this.preferredDefinitionList;
        return this.newPlaybackDownloadTask(string3, l2, l3, string, string2, bl, (List<VideoDefinition>)object, n2);
    }

    public Observable<DownloadTask> newPlaybackDownloadTask(String string, long l2, long l3, String string2, String string3, boolean bl) {
        DownloadManager downloadManager = list;
        List<VideoDefinition> list = ((DownloadManager)((Object)list)).preferredDefinitionList;
        return downloadManager.newPlaybackDownloadTask(string, l2, l3, string2, string3, bl, list);
    }

    public Observable<DownloadTask> newPlaybackDownloadTask(String string, long l2, long l3, String string2, String string3, boolean bl, List<VideoDefinition> list) {
        return this.newPlaybackDownloadTask(string, l2, l3, string2, string3, bl, list, -1);
    }

    public Observable<DownloadTask> newPlaybackDownloadTask(String string, long l2, long l3, String string2, String string3, boolean bl, List<VideoDefinition> list, int n2) {
        return this.mDataLoader.getLoadRoomInfoObservable(String.valueOf(l2), l3, n2, string2, true).map(pBRoomData -> {
            List list = list;
            list = VideoDefinition.from(pBRoomData.playbackDefDefinition);
            for (Object object3 : list) {
                if ((object3 != VideoDefinition.Audio || TextUtils.isEmpty((CharSequence)pBRoomData.audioUrl)) && !w1.b(pBRoomData, object3)) continue;
                list = object3;
                break;
            }
            if (list != null) {
                if (pBRoomData.packageSignal != null) {
                    DownloadModel downloadModel;
                    DownloadModel downloadModel2;
                    Object object3;
                    Object object4 = VideoDefinition.Audio;
                    if (list == object4) {
                        CDNInfo cDNInfo;
                        pBRoomData.playInfo.audio = new PlayItem();
                        pBRoomData.playInfo.audio.cdnList = new CDNInfo[1];
                        object3 = cDNInfo;
                        ((CDNInfo)object3)();
                        ((CDNInfo)object3).url = pBRoomData.audioUrl;
                        cDNInfo.size = pBRoomData.audioSize;
                        pBRoomData.playInfo.audio.cdnList[0] = object3;
                    }
                    Object object5 = object4;
                    object4 = downloadModel2;
                    ((DownloadModel)object4)();
                    object3 = w1.a(pBRoomData, (VideoDefinition)((Object)((Object)list)));
                    downloadModel2.playItem = new VideoDataSourceHelper().getPlayInfoByDefinition((VideoItem)pBRoomData, (VideoDefinition)((Object)((Object)list)));
                    if (list == object5) {
                        String string3;
                        ((DownloadModel)object4).url = string3 = ((CDNInfo)object3).url;
                        ((DownloadModel)object4).fileType = FileType.AUDIO;
                        ((DownloadModel)object4).availableCDN.add(string3);
                    } else {
                        Object object6 = object4;
                        ((DownloadModel)object6).url = VideoPlayerUtils.decodeUrl(((CDNInfo)object3).enc_url);
                        ((DownloadModel)object6).fileType = FileType.VIDEO;
                        CDNInfo[] cDNInfoArray = ((DownloadModel)object6).playItem.cdnList;
                        int n2 = ((DownloadModel)object6).playItem.cdnList.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            CDNInfo cDNInfo = cDNInfoArray[i2];
                            ((DownloadModel)object4).availableCDN.add(VideoPlayerUtils.decodeUrl(cDNInfo.enc_url));
                        }
                    }
                    ((DownloadModel)object4).definition = list;
                    ((DownloadModel)object4).videoId = pBRoomData.videoId;
                    ((DownloadModel)object4).sessionId = l3;
                    ((DownloadModel)object4).version = pBRoomData.version;
                    ((DownloadModel)object4).videoDuration = pBRoomData.duration;
                    ((DownloadModel)object4).roomId = l2;
                    list = VideoPlayerUtils.replaceIllegalChar(string);
                    ((DownloadModel)object4).targetName = (String)((Object)list) + "_" + pBRoomData.videoId + "." + MimeTypeMap.getFileExtensionFromUrl((String)((DownloadModel)object4).url);
                    ((DownloadModel)object4).videoName = pBRoomData.videoInfo.title;
                    ((DownloadModel)object4).isEncrypt = bl;
                    ((DownloadModel)object4).videoToken = string2;
                    ((DownloadModel)object4).extraInfo = string3;
                    ((DownloadModel)object4).totalLength = ((CDNInfo)object3).size;
                    ((DownloadModel)object4).targetFolder = this.getTargetFolder();
                    ((DownloadModel)object4).recordType = pBRoomData.recordType;
                    ((DownloadModel)object4).templateName = pBRoomData.templateName;
                    ((DownloadModel)object4).smallCourseRecordType = pBRoomData.smallCourseRecordType;
                    ((DownloadModel)object4).live1v1BlackboardPages = pBRoomData.live1v1BlackboardPages;
                    ((DownloadModel)object4).whiteboardUrl = pBRoomData.whiteboardUrl;
                    ((DownloadModel)object4).partnerId = pBRoomData.videoInfo.partnerId;
                    ((DownloadModel)object4).guid = pBRoomData.guid;
                    ((DownloadModel)object4).partnerConfig = pBRoomData.partnerConfig;
                    ((DownloadModel)object4).coverUrl = pBRoomData.initPicture;
                    ((DownloadModel)object4).isVideoMain = pBRoomData.isVideoMain;
                    ((DownloadModel)object4).invalidTs = pBRoomData.invalidTs;
                    ((DownloadModel)object4).horseLamp = pBRoomData.horseLamp;
                    ((DownloadModel)object4).subtitleItems = pBRoomData.subtitleItems;
                    ((DownloadModel)object4).playbackId = pBRoomData.playbackId;
                    Object object7 = string = downloadModel;
                    ((DownloadModel)((Object)string))();
                    ((DownloadModel)object2).url = pBRoomData.packageSignal.packageUrl;
                    ((DownloadModel)object2).extraInfo = string3;
                    ((DownloadModel)object2).videoId = pBRoomData.videoId;
                    ((DownloadModel)object2).sessionId = l3;
                    ((DownloadModel)object2).version = pBRoomData.version;
                    ((DownloadModel)object7).roomId = l2;
                    ((DownloadModel)object7).fileType = FileType.SIGNAL;
                    ((DownloadModel)object7).targetName = "s_" + (String)((Object)list) + "_" + pBRoomData.videoId;
                    ((DownloadModel)object7).videoName = "s_" + pBRoomData.videoInfo.title;
                    ((DownloadModel)object2).isEncrypt = bl;
                    ((DownloadModel)object2).videoToken = string2;
                    ((DownloadModel)object2).totalLength = pBRoomData.packageSignal.packageSize;
                    ((DownloadModel)object2).targetFolder = this.getTargetFolder();
                    ((DownloadModel)object2).recordType = pBRoomData.recordType;
                    ((DownloadModel)object2).templateName = pBRoomData.templateName;
                    ((DownloadModel)object2).smallCourseRecordType = pBRoomData.smallCourseRecordType;
                    ((DownloadModel)object2).live1v1BlackboardPages = pBRoomData.live1v1BlackboardPages;
                    ((DownloadModel)object2).whiteboardUrl = pBRoomData.whiteboardUrl;
                    ((DownloadModel)object2).partnerId = pBRoomData.videoInfo.partnerId;
                    ((DownloadModel)object2).guid = pBRoomData.guid;
                    ((DownloadModel)object2).partnerConfig = pBRoomData.partnerConfig;
                    ((DownloadModel)object2).coverUrl = pBRoomData.initPicture;
                    ((DownloadModel)object2).isVideoMain = pBRoomData.isVideoMain;
                    ((DownloadModel)object2).invalidTs = pBRoomData.invalidTs;
                    ((DownloadModel)object2).horseLamp = pBRoomData.horseLamp;
                    ((DownloadModel)object2).subtitleItems = pBRoomData.subtitleItems;
                    downloadModel.playbackId = pBRoomData.playbackId;
                    ((DownloadModel)object4).nextModel = downloadModel;
                    return object4;
                }
                throw new Exception("\u6ca1\u6709\u6536\u5230\u79bb\u7ebf\u4e0b\u8f7d\u4fe1\u4ee4");
            }
            throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6e05\u6670\u5ea6");
        }).map(this::newPlayBackTask).subscribeOn(Schedulers.io());
    }

    public Observable<DownloadTask> newVideoDownloadTask(String string, long l2, String string2, String string3) {
        return this.newVideoDownloadTask(string, l2, string2, string3, "");
    }

    public Observable<DownloadTask> newVideoDownloadTask(String string, long l2, String string2, String string3, String string4) {
        boolean bl = BJYPlayerSDK.IS_ENCRYPT;
        return this.newVideoDownloadTask(string, l2, string2, string3, string4, bl);
    }

    public Observable<DownloadTask> newVideoDownloadTask(String string, long l2, String string2, String string3, String string4, boolean bl) {
        DownloadManager downloadManager = list;
        List<VideoDefinition> list = ((DownloadManager)((Object)list)).preferredDefinitionList;
        return downloadManager.newVideoDownloadTask(string, l2, string2, string3, string4, bl, list);
    }

    public Observable<DownloadTask> newVideoDownloadTask(String string, long l2, String string2, String string3, String string4, boolean bl, List<VideoDefinition> list) {
        return this.mDataLoader.getLoadVideoInfoObservable(l2, string2, string4).flatMap(videoItem -> Observable.create(observableEmitter -> {
            DownloadModel downloadModel;
            Object object32;
            List list = list;
            list = VideoDefinition.from(((VideoItem)object).vodDefaultDefinition);
            for (Object object32 : list) {
                if ((object32 != VideoDefinition.Audio || TextUtils.isEmpty((CharSequence)((VideoItem)object).audioUrl)) && !w1.b(videoItem, object32)) continue;
                list = object32;
                break;
            }
            if (list == null) {
                Throwable throwable;
                Throwable throwable2 = throwable;
                throwable = new Throwable("definition not found");
                observableEmitter.onError(throwable2);
                return;
            }
            Object object4 = VideoDefinition.Audio;
            if (list == object4) {
                CDNInfo cDNInfo;
                ((VideoItem)object).playInfo.audio = new PlayItem();
                ((VideoItem)object).playInfo.audio.cdnList = new CDNInfo[1];
                object32 = cDNInfo;
                ((CDNInfo)object32)();
                ((CDNInfo)object32).url = ((VideoItem)object).audioUrl;
                cDNInfo.size = ((VideoItem)object).audioSize;
                ((VideoItem)object).playInfo.audio.cdnList[0] = object32;
            }
            object32 = downloadModel;
            downloadModel = new DownloadModel();
            CDNInfo cDNInfo = w1.a(videoItem, (VideoDefinition)((Object)((Object)((Object)list))));
            if (list == object4) {
                object4 = cDNInfo.url;
                ((DownloadModel)object32).url = object4;
                ((DownloadModel)object32).fileType = FileType.AUDIO;
                ((DownloadModel)object32).availableCDN.add((String)object4);
            } else {
                Object object5 = object32;
                ((DownloadModel)object5).url = VideoPlayerUtils.decodeUrl(cDNInfo.enc_url);
                ((DownloadModel)object5).fileType = FileType.VIDEO;
                VideoDataSourceHelper videoDataSourceHelper = new VideoDataSourceHelper();
                object4 = videoDataSourceHelper.getPlayInfoByDefinition((VideoItem)object, (VideoDefinition)((Object)((Object)((Object)((Object)((Object)((Object)object2))))))).cdnList;
                int n2 = videoDataSourceHelper.getPlayInfoByDefinition((VideoItem)object, (VideoDefinition)((Object)((Object)((Object)((Object)((Object)((Object)object2))))))).cdnList.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    CDNInfo cDNInfo2 = object4[i2];
                    ((DownloadModel)object32).availableCDN.add(VideoPlayerUtils.decodeUrl(cDNInfo2.enc_url));
                }
            }
            Object object6 = object32;
            ((DownloadModel)object32).totalLength = cDNInfo.size;
            ((DownloadModel)object32).definition = list;
            ((DownloadModel)object32).videoId = ((VideoItem)object).videoId;
            ((DownloadModel)object32).videoToken = string2;
            ((DownloadModel)object6).extraInfo = string3;
            ((DownloadModel)object6).playItem = new VideoDataSourceHelper().getPlayInfoByDefinition((VideoItem)videoItem, (VideoDefinition)((Object)((Object)((Object)list))));
            ((DownloadModel)object32).partnerId = ((VideoItem)object).videoInfo.partnerId;
            ((DownloadModel)object32).guid = ((VideoItem)object).guid;
            ((DownloadModel)object32).subtitleItems = ((VideoItem)object).subtitleItems;
            ((DownloadModel)object32).keyFrameModelList = ((VideoItem)object).keyFrameModelList;
            ((DownloadModel)object32).coverUrl = ((VideoItem)object).initPicture;
            ((DownloadModel)object32).horseLamp = ((VideoItem)object).horseLamp;
            list = null;
            boolean bl2 = false;
            for (DownloadTask downloadTask : ((DownloadManager)((Object)throwable2)).taskList) {
                if (!downloadTask.getVideoDownloadInfo().equals(object32) || !(downloadTask instanceof DownloadTaskImpl)) continue;
                list = (DownloadTaskImpl)downloadTask;
                DownloadModel downloadModel2 = ((DownloadTaskImpl)object2).b;
                downloadModel2.url = ((DownloadModel)object32).url;
                downloadModel2.videoToken = ((DownloadModel)object32).videoToken;
                ((DownloadTaskImpl)object2).b.targetFolder = ((DownloadManager)((Object)throwable2)).targetFolder;
                boolean bl3 = true;
                object32 = downloadModel2;
                bl2 = bl3;
                break;
            }
            if (!bl2) {
                DownloadTaskImpl downloadTaskImpl;
                Object object7 = object32;
                Object object8 = object32;
                VideoItem videoItem = videoItem;
                VideoItem videoItem2 = videoItem;
                videoItem = VideoPlayerUtils.replaceIllegalChar(string);
                ((DownloadModel)object32).targetName = (String)((Object)videoItem) + "_" + l2 + "." + MimeTypeMap.getFileExtensionFromUrl((String)((DownloadModel)object32).url);
                ((DownloadModel)object32).videoName = videoItem2.videoInfo.title;
                ((DownloadModel)object32).videoDuration = videoItem.duration;
                ((DownloadModel)object8).targetFolder = ((DownloadManager)((Object)throwable2)).targetFolder;
                ((DownloadModel)object8).downloadLength = 0L;
                ((DownloadModel)object7).isEncrypt = bl;
                ((DownloadModel)object7).status = TaskStatus.New;
                ((DownloadModel)object32).videoToken = string2;
                ((DownloadModel)object32).extraInfo = string3;
                list = downloadTaskImpl;
                ((DownloadTaskImpl)((Object)list))((DownloadModel)object32);
                downloadTaskImpl.a(((DownloadManager)((Object)throwable2)).defaultThreadPool);
                ((DownloadManager)((Object)throwable2)).taskList.add((DownloadTask)((Object)list));
            }
            ObservableEmitter observableEmitter2 = observableEmitter;
            ((DownloadTaskImpl)((Object)list)).a(((DownloadManager)((Object)throwable2)).globalInternalListener);
            ((DownloadManager)((Object)throwable2)).globalInternalListener.d((DownloadModel)object32);
            observableEmitter2.onNext(list);
            observableEmitter2.onComplete();
        })).subscribeOn(Schedulers.io());
    }

    public void setTargetFolder(String string) {
        String string2 = File.separator;
        if (!string.endsWith(string2)) {
            string = string.concat(string2);
        }
        this.targetFolder = string;
    }

    public String getTargetFolder() {
        return this.targetFolder;
    }

    public List<DownloadTask> getAllTasks() {
        return this.taskList;
    }

    public DownloadTask getTaskByVideoId(long l2) {
        for (DownloadTask downloadTask : ((DownloadManager)this).taskList) {
            if (downloadTask.getVideoDownloadInfo().videoId != l2) continue;
            return downloadTask;
        }
        return null;
    }

    public DownloadTask getTaskByVideoId(long l2, FileType fileType) {
        for (DownloadTask downloadTask : ((DownloadManager)this).taskList) {
            if (downloadTask.getVideoDownloadInfo().videoId != l2 || downloadTask.getVideoDownloadInfo().fileType != fileType) continue;
            return downloadTask;
        }
        return null;
    }

    public DownloadTask getTaskByRoom(long l2, long l3) {
        for (DownloadTask downloadTask : ((DownloadManager)this).taskList) {
            if (downloadTask.getVideoDownloadInfo().roomId != l2 || downloadTask.getVideoDownloadInfo().sessionId != l3) continue;
            return downloadTask;
        }
        return null;
    }

    public List<DownloadTask> getSingleTaskList() {
        ArrayList arrayList;
        DownloadManager downloadManager = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (DownloadTask downloadTask : downloadManager.taskList) {
            if (downloadTask.getVideoDownloadInfo().nextModel != null) continue;
            arrayList2.add(downloadTask);
        }
        return arrayList2;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.defaultThreadPool = executorService;
    }

    public void registerNetReceiver(OnNetChangeListener onNetChangeListener) {
        if (this.netChangeReceiver == null) {
            NetChangeReceiver netChangeReceiver;
            IntentFilter intentFilter;
            IntentFilter intentFilter2 = intentFilter;
            intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            NetChangeReceiver netChangeReceiver2 = netChangeReceiver;
            this.netChangeReceiver = new NetChangeReceiver();
            this.context.registerReceiver((BroadcastReceiver)netChangeReceiver2, intentFilter2);
        }
        this.onNetChangeListener = onNetChangeListener;
    }

    public void unregisterNetReceiver() {
        NetChangeReceiver netChangeReceiver = this.netChangeReceiver;
        if (netChangeReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)netChangeReceiver);
            this.netChangeReceiver = null;
        }
        this.onNetChangeListener = null;
    }

    public void setPreferredDefinitionList(List<VideoDefinition> list) {
        this.preferredDefinitionList = list;
    }

    public class NetChangeReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            int n2 = NetUtils.getNetworkType((Context)context);
            if (n2 == 3) {
                DownloadManager.this.onNetChangeListener.onWifi();
            } else if (n2 != 2 && n2 != 4) {
                if (n2 <= 1) {
                    DownloadManager.this.onNetChangeListener.onDisConnect();
                } else {
                    DownloadManager.this.onNetChangeListener.onNoAvailable();
                }
            } else {
                DownloadManager.this.onNetChangeListener.onMobile();
            }
        }
    }

    public class b
    implements t {
        public b() {
        }

        public /* synthetic */ b(a a2) {
            this();
        }

        @Override
        public void d(DownloadModel downloadModel) {
            if (((b)((Object)string)).DownloadManager.this.modelList.contains(downloadModel)) {
                ((b)((Object)string)).DownloadManager.this.modelList.set(((b)((Object)string)).DownloadManager.this.modelList.indexOf(downloadModel), downloadModel);
            } else {
                ((b)((Object)string)).DownloadManager.this.modelList.add(downloadModel);
            }
            DownloadModel downloadModel2 = downloadModel;
            String string = downloadModel2.getKey();
            ((b)((Object)string)).DownloadManager.this.kv.encode(string, JsonUtils.a(downloadModel2));
        }

        @Override
        public void e(DownloadModel downloadModel) {
            b b2 = this;
            b2.DownloadManager.this.modelList.remove(downloadModel);
            for (DownloadTask downloadTask : b2.DownloadManager.this.taskList) {
                if (!downloadTask.getVideoDownloadInfo().equals(downloadModel)) continue;
                DownloadManager.this.taskList.remove(downloadTask);
                break;
            }
            DownloadManager.this.kv.remove(downloadModel.getKey());
        }
    }
}

