/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.baijiayun.videoplayer.bean.VideoItem;
import com.baijiayun.videoplayer.core.R;
import com.baijiayun.videoplayer.listeners.OnVideoSizeChangedListener;
import com.baijiayun.videoplayer.player.IPlayer;
import com.baijiayun.videoplayer.render.AspectRatio;
import com.baijiayun.videoplayer.render.IRender;
import com.baijiayun.videoplayer.render.RenderSurfaceView;
import com.baijiayun.videoplayer.render.RenderTextureView;
import com.baijiayun.videoplayer.x1;

public class BJYPlayerView
extends FrameLayout {
    private static final String TAG = "BJYPlayerView";
    private int mRenderType;
    private IRender mRender;
    private IRender.IRenderHolder mRenderHolder;
    private IPlayer internalPlayer;
    private x1 watermarkView;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private int mAspectRatio;
    private OnVideoSizeChangedListener videoSizeChangedListener;
    private IRender.IRenderCallback mRenderCallback;

    public BJYPlayerView(@NonNull Context context) {
        this(context, null);
    }

    public BJYPlayerView(@NonNull Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BJYPlayerView(@NonNull Context object, AttributeSet attributeSet, int n2) {
        Context context = object;
        super((Context)object, attributeSet, n2);
        this.mRenderType = 1;
        object = AspectRatio.AspectRatio_FIT_PARENT;
        this.mAspectRatio = ((Enum)object).ordinal();
        this.mRenderCallback = new IRender.IRenderCallback(){

            @Override
            public void onSurfaceCreated(IRender.IRenderHolder iRenderHolder, int n2, int n3) {
                a a2 = this;
                BJYPlayerView.access$002(a2.BJYPlayerView.this, iRenderHolder);
                BJYPlayerView bJYPlayerView = a2.BJYPlayerView.this;
                bJYPlayerView.bindRenderHolder(bJYPlayerView.mRenderHolder);
                if (a2.BJYPlayerView.this.videoSizeChangedListener != null) {
                    BJYPlayerView.this.videoSizeChangedListener.onVideoSizeChanged(n2, n3);
                }
            }

            @Override
            public void onSurfaceChanged(IRender.IRenderHolder iRenderHolder, int n2, int n3, int n4) {
                if (BJYPlayerView.this.watermarkView != null) {
                    a a2 = this;
                    a2.BJYPlayerView.this.watermarkView.a(BJYPlayerView.this.getWidth(), BJYPlayerView.this.getHeight());
                    a2.BJYPlayerView.this.watermarkView.c(BJYPlayerView.this.mVideoWidth, BJYPlayerView.this.mVideoHeight);
                    a2.BJYPlayerView.this.watermarkView.b(BJYPlayerView.this.mVideoSarNum, BJYPlayerView.this.mVideoSarDen);
                    a2.BJYPlayerView.this.watermarkView.a();
                }
                if (BJYPlayerView.this.videoSizeChangedListener != null) {
                    BJYPlayerView.this.videoSizeChangedListener.onVideoSizeChanged(n3, n4);
                }
            }

            @Override
            public void onSurfaceDestroy(IRender.IRenderHolder iRenderHolder) {
                BJYPlayerView.access$002(BJYPlayerView.this, null);
            }
        };
        attributeSet = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.BJVideoView, 0, 0);
        if (attributeSet.hasValue(R.styleable.BJVideoView_bjy_aspect_ratio)) {
            int n3 = R.styleable.BJVideoView_bjy_aspect_ratio;
            this.mAspectRatio = attributeSet.getInt(n3, ((Enum)object).ordinal());
        }
        if (attributeSet.hasValue(R.styleable.BJVideoView_bjy_render_type)) {
            this.mRenderType = attributeSet.getInt(R.styleable.BJVideoView_bjy_render_type, 1);
        }
        attributeSet.recycle();
    }

    private void init() {
        BJYPlayerView bJYPlayerView = this;
        bJYPlayerView.setRenderType(bJYPlayerView.mRenderType);
        bJYPlayerView.setAspectRatio(AspectRatio.values()[this.mAspectRatio]);
        bJYPlayerView.setBackgroundColor(-16777216);
    }

    private void releaseRender() {
        IRender iRender = this.mRender;
        if (iRender != null) {
            iRender.release();
            this.mRender = null;
        }
        if (this.videoSizeChangedListener != null) {
            this.videoSizeChangedListener = null;
        }
    }

    private void bindRenderHolder(IRender.IRenderHolder iRenderHolder) {
        if (iRenderHolder != null) {
            iRenderHolder.bindPlayer(this.internalPlayer);
        }
    }

    public static /* synthetic */ IRender.IRenderHolder access$002(BJYPlayerView bJYPlayerView, IRender.IRenderHolder iRenderHolder) {
        bJYPlayerView.mRenderHolder = iRenderHolder;
        return iRenderHolder;
    }

    public void setVideoPlayer(IPlayer iPlayer) {
        this.internalPlayer = iPlayer;
        this.init();
    }

    public void setRenderType(int n2) {
        this.setRenderType(n2, false);
    }

    public void reset() {
        BJYPlayerView bJYPlayerView = this;
        bJYPlayerView.internalPlayer.reset();
        bJYPlayerView.setRenderType(bJYPlayerView.mRenderType, true);
    }

    public void setRenderType(int n2, boolean bl) {
        FrameLayout.LayoutParams layoutParams;
        if (!(this.mRenderType != n2) && this.mRender != null && !bl) {
            return;
        }
        this.releaseRender();
        this.mRenderType = n2;
        if (n2 != 0) {
            if (n2 == 1) {
                this.mRender = new RenderSurfaceView(this.getContext());
            }
        } else {
            this.mRender = new RenderTextureView(this.getContext());
        }
        BJYPlayerView bJYPlayerView = this;
        bJYPlayerView.mRenderHolder = null;
        bJYPlayerView.internalPlayer.setSurface(null);
        bJYPlayerView.mRender.setRenderCallback(this.mRenderCallback);
        BJYPlayerView bJYPlayerView2 = this;
        n2 = bJYPlayerView2.mVideoWidth;
        bJYPlayerView.mRender.updateVideoSize(n2, bJYPlayerView2.mVideoHeight);
        BJYPlayerView bJYPlayerView3 = this;
        n2 = bJYPlayerView3.mVideoSarNum;
        bJYPlayerView.mRender.setVideoSampleAspectRatio(n2, bJYPlayerView3.mVideoSarDen);
        bJYPlayerView.removeAllViews();
        Object object = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-2, -2, 17);
        bJYPlayerView.addView(bJYPlayerView.mRender.getRenderView(), (ViewGroup.LayoutParams)object);
        object = bJYPlayerView.watermarkView;
        if (object != null) {
            BJYPlayerView bJYPlayerView4 = this;
            BJYPlayerView bJYPlayerView5 = this;
            int n3 = bJYPlayerView5.mVideoWidth;
            ((x1)((Object)object)).c(n3, bJYPlayerView5.mVideoHeight);
            BJYPlayerView bJYPlayerView6 = this;
            int n4 = bJYPlayerView6.mVideoSarNum;
            bJYPlayerView4.watermarkView.b(n4, bJYPlayerView6.mVideoSarDen);
            bJYPlayerView4.watermarkView.a(AspectRatio.AspectRatio_FIT_PARENT);
            bJYPlayerView4.watermarkView.a();
            bJYPlayerView4.addView((View)bJYPlayerView4.watermarkView);
        }
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        IRender iRender = ((BJYPlayerView)((Object)this)).mRender;
        if (iRender != null) {
            iRender.updateAspectRatio(aspectRatio);
        }
        if ((this = ((BJYPlayerView)((Object)this)).watermarkView) != null) {
            ((x1)((Object)this)).a(aspectRatio);
        }
    }

    public void bindRender() {
        BJYPlayerView bJYPlayerView = this;
        bJYPlayerView.bindRenderHolder(bJYPlayerView.mRenderHolder);
    }

    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    public void onVideoSizeChange(int n2, int n3, int n4, int n5) {
        this.mVideoWidth = n2;
        this.mVideoHeight = n3;
        this.mVideoSarNum = n4;
        this.mVideoSarDen = n5;
        Object object = this.mRender;
        if (object != null) {
            object.updateVideoSize(n2, n3);
            this.mRender.setVideoSampleAspectRatio(n4, n5);
        }
        if ((object = this.watermarkView) != null) {
            BJYPlayerView bJYPlayerView = this;
            ((x1)((Object)object)).c(n2, n3);
            bJYPlayerView.watermarkView.b(n4, n5);
            bJYPlayerView.watermarkView.a();
        }
    }

    public void showWaterMark(VideoItem.WaterMark object) {
        boolean bl = object == null || TextUtils.isEmpty((CharSequence)object.url) || object.pos == null;
        if (bl) {
            object = this.watermarkView;
            if (object != null) {
                if (this == object.getParent()) {
                    BJYPlayerView bJYPlayerView = this;
                    bJYPlayerView.removeView((View)bJYPlayerView.watermarkView);
                }
                this.watermarkView = null;
            }
        } else {
            x1 x12 = this.watermarkView;
            if (x12 == null) {
                this.watermarkView = new x1(this.getContext());
            } else {
                this.removeView((View)x12);
            }
            BJYPlayerView bJYPlayerView = this;
            bJYPlayerView.watermarkView.a((VideoItem.WaterMark)object);
            BJYPlayerView bJYPlayerView2 = this;
            int n2 = bJYPlayerView2.getWidth();
            bJYPlayerView.watermarkView.a(n2, bJYPlayerView2.getHeight());
            BJYPlayerView bJYPlayerView3 = this;
            n2 = bJYPlayerView3.mVideoWidth;
            bJYPlayerView.watermarkView.c(n2, bJYPlayerView3.mVideoHeight);
            BJYPlayerView bJYPlayerView4 = this;
            int n3 = bJYPlayerView4.mVideoSarNum;
            bJYPlayerView.watermarkView.b(n3, bJYPlayerView4.mVideoSarDen);
            bJYPlayerView.watermarkView.a();
            bJYPlayerView.addView((View)bJYPlayerView.watermarkView);
        }
    }

    public void setOnVideoSizeListener(OnVideoSizeChangedListener onVideoSizeChangedListener) {
        this.videoSizeChangedListener = onVideoSizeChangedListener;
    }
}

