/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.TrafficStats;
import android.os.Build;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.baijiayun.constant.VideoDefinition;
import com.baijiayun.videoplayer.core.R;
import com.baijiayun.videoplayer.util.BASE64;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class VideoPlayerUtils {
    private static final String SP_NAME = "sp_bj_video_player";
    private static final String SP_KEY_HAS_UUID = "sp_key_has_uuid";
    private static final String SP_KEY_UUID = "sp_key_uuid";
    private static final String SP_KEY_CUR_USER_DB_INFO = "sp_key_cur_user_info";
    private static SharedPreferences sp;

    public static void init(Context context) {
        Context context2 = context;
        sp = context2.getSharedPreferences(SP_NAME, 0);
        VideoPlayerUtils.getUUID(context2);
    }

    public static String formatDuration(int n2) {
        String string;
        int n3 = Math.abs(n2);
        int n4 = n3 / 3600;
        int n5 = n3 % 3600;
        n3 = n5 / 60;
        int n6 = n5 % 60 % 60;
        if (n4 > 0) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n4;
            objectArray2[1] = n3;
            objectArray[2] = n6;
            string = String.format("%02d:%02d:%02d", objectArray2);
        } else {
            Object[] objectArray = new Object[2];
            Object[] objectArray3 = objectArray;
            objectArray3[0] = n3;
            objectArray[1] = n6;
            string = String.format("%02d:%02d", objectArray3);
        }
        if (n2 < 0) {
            string = "- " + string;
        }
        return string;
    }

    public static String formatDurationMs(int n2) {
        int n3 = n2;
        int n4 = n3 / 3600 / 1000;
        int n5 = n2 / 1000 % 3600 / 60;
        int n6 = (int)Math.ceil((double)(n3 - n4 * 3600 * 1000 - n5 * 60 * 1000) / 1000.0);
        if (n6 >= 60) {
            n6 -= 60;
            ++n5;
        }
        if (n5 >= 60) {
            n5 -= 60;
            ++n4;
        }
        Object[] objectArray = new Object[3];
        Object object = objectArray;
        object[0] = n4;
        object[1] = n5;
        objectArray[2] = n6;
        object = String.format("%02d:%02d:%02d", object);
        if (n2 < 0) {
            object = "- " + (String)object;
        }
        return object;
    }

    public static int formatDuration(String stringArray) {
        stringArray = stringArray.split(":");
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        return Integer.parseInt(stringArray[0]) * 3600 + n2 * 60 + n3;
    }

    public static String formatDuration(int n2, boolean bl) {
        Object object;
        int n3 = Math.abs(n2);
        int n4 = n3 / 3600;
        int n5 = n3 % 3600;
        n3 = n5 / 60;
        int n6 = n5 % 60 % 60;
        if (n4 <= 0 && !bl) {
            Object[] objectArray = new Object[2];
            object = objectArray;
            object[0] = n3;
            objectArray[1] = n6;
            object = String.format("%02d:%02d", object);
        } else {
            Object[] objectArray = new Object[3];
            object = objectArray;
            object[0] = n4;
            object[1] = n3;
            objectArray[2] = n6;
            object = String.format("%02d:%02d:%02d", object);
        }
        if (n2 < 0) {
            object = "- " + (String)object;
        }
        return object;
    }

    public static String formatSpeed(long l2, long l3) {
        float f2;
        if (l3 <= 0L) {
            return "0 B/s";
        }
        if (l2 <= 0L) {
            return "0 B/s";
        }
        float f3 = (float)l2 * 1000.0f / (float)l3;
        if (f2 >= 1000000.0f) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Float.valueOf(f3 / 1000.0f / 1000.0f);
            return String.format(Locale.US, "%.2f MB/s", objectArray2);
        }
        if (f3 >= 1000.0f) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = Float.valueOf(f3 / 1000.0f);
            return String.format(Locale.US, "%.1f KB/s", objectArray3);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray4 = objectArray;
        objectArray[0] = (long)f3;
        return String.format(Locale.US, "%d B/s", objectArray4);
    }

    public static String formatDurationMilli(long l2) {
        if (l2 >= 1000L) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Float.valueOf((float)l2 / 1000.0f);
            return String.format(Locale.US, "%.2f sec", objectArray2);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray3 = objectArray;
        objectArray[0] = l2;
        return String.format(Locale.US, "%d msec", objectArray3);
    }

    public static String formatSize(long l2) {
        if (l2 >= 100000L) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = Float.valueOf((float)l2 / 1000.0f / 1000.0f);
            return String.format(Locale.US, "%.2f MB", objectArray2);
        }
        if (l2 >= 100L) {
            Object[] objectArray = new Object[1];
            Object[] objectArray3 = objectArray;
            objectArray[0] = Float.valueOf((float)l2 / 1000.0f);
            return String.format(Locale.US, "%.1f KB", objectArray3);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray4 = objectArray;
        objectArray[0] = l2;
        return String.format(Locale.US, "%d B", objectArray4);
    }

    public static String decodeUrl(String string) {
        if (string != null && string.startsWith("bjcloudvod://")) {
            StringBuilder stringBuilder;
            Object object = string.substring(13);
            char[] cArray = new String(BASE64.getUrlDecoder().decode(((String)object).getBytes("UTF-8")), "ISO8859-1").toCharArray();
            object = cArray;
            byte by = (byte)(cArray[0] % 8);
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            int n2 = cArray.length - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                StringBuilder stringBuilder3 = stringBuilder2;
                Object object2 = object;
                int n3 = i2 % 4;
                char c2 = (char)(n3 * by + i2 % 3 + 1);
                Object object3 = object2[i2];
                stringBuilder3.append((char)(object3 - c2));
            }
            try {
                return stringBuilder2.toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return string;
            }
        }
        return string;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void simpleEncryptFile(String object) {
        RandomAccessFile randomAccessFile;
        File file;
        Object object2 = file;
        if (!new File((String)object).exists()) return;
        object = randomAccessFile;
        randomAccessFile = new RandomAccessFile((File)object2, "rw");
        byte[] byArray = new byte[64];
        object2 = byArray;
        randomAccessFile.read(byArray);
        for (int i2 = 0; i2 < 64; ++i2) {
            Object object3 = object2;
            int n2 = i2;
            Object object4 = object2[i2];
            object3[n2] = (byte)(object4 ^ 0xFF);
            continue;
        }
        Object object5 = object;
        Object object6 = object5;
        ((RandomAccessFile)object5).seek(0L);
        ((RandomAccessFile)object5).write((byte[])object2);
        ((RandomAccessFile)object6).close();
        return;
        catch (Throwable throwable) {
            try {
                ((RandomAccessFile)object).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static String getUUID(Context object) {
        if (sp == null) {
            if (object == null) {
                return "";
            }
            sp = object.getSharedPreferences(SP_NAME, 0);
        }
        if (sp.getBoolean(SP_KEY_HAS_UUID, false)) {
            return sp.getString(SP_KEY_UUID, "");
        }
        object = VideoPlayerUtils.generateUUID();
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(SP_KEY_UUID, (String)object);
        editor.putBoolean(SP_KEY_HAS_UUID, true);
        editor.apply();
        return object;
    }

    private static String generateUUID() {
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray[0] = VideoPlayerUtils.seed() + VideoPlayerUtils.seed();
        objectArray[1] = VideoPlayerUtils.seed();
        objectArray[2] = VideoPlayerUtils.seed();
        objectArray[3] = VideoPlayerUtils.seed();
        objectArray[4] = VideoPlayerUtils.seed() + VideoPlayerUtils.seed() + VideoPlayerUtils.seed();
        return String.format("%s-%s-%s-%s-%s", objectArray2);
    }

    private static String seed() {
        return Integer.toHexString((int)((Math.random() + 1.0) * 65536.0)).substring(1);
    }

    public static String encodeHeadInfo(String string) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u001f' && c2 < '\u007f') {
                stringBuffer2.append(c2);
                continue;
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = (int)c2;
            stringBuffer2.append(String.format("\\u%04x", objectArray2));
        }
        return stringBuffer2.toString();
    }

    public static String getUAString(Context context) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2;
        StringBuffer stringBuffer3 = stringBuffer2 = stringBuffer;
        stringBuffer3();
        stringBuffer3.append(Build.BRAND);
        stringBuffer3.append(Build.MODEL);
        stringBuffer3.append("-android-");
        stringBuffer3.append(Build.VERSION.RELEASE);
        stringBuffer3.append("|");
        context = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        stringBuffer.append(context.packageName);
        stringBuffer.append(context.versionName);
        stringBuffer.append("|BJVideoPlayer");
        try {
            stringBuffer.append("4.25.0");
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        return stringBuffer2.toString();
    }

    public static long getTotalRxBytes(Context context) {
        long l2;
        block3: {
            try {
                l2 = TrafficStats.getUidRxBytes((int)context.getApplicationInfo().uid);
                if (l2 != -1L) break block3;
            }
            catch (Exception exception) {
                Log.e((String)"BJPlayerView", (String)"getTotalRxBytes error !");
                return 0L;
            }
            Log.w((String)"BJPlayerView", (String)"getTotalRxBytes unsupported !");
            return 0L;
        }
        return l2;
    }

    public static String replaceIllegalChar(String string) {
        return Pattern.compile("[\\\\/:\\*\\?<>\\|]").matcher(string).replaceAll("");
    }

    public static void deleteFile(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                VideoPlayerUtils.deleteFile(fileArray[i2]);
            }
            file.delete();
        } else if (file.exists()) {
            file.delete();
        }
    }

    public static String md5(String object) {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(((String)object).getBytes("UTF-8"));
        object = messageDigest.digest();
        try {
            return new BigInteger(1, (byte[])object).toString(16);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        throw new AssertionError();
    }

    public static byte[] md5WithByte(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(string.getBytes("UTF-8"));
            return messageDigest.digest();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        throw new AssertionError();
    }

    public static <T> boolean isEmptyList(List<T> list) {
        return list == null || list.size() == 0;
    }

    public static String getAndroidVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getDeviceName() {
        String string = Build.MODEL;
        String string2 = Build.MANUFACTURER;
        if (string.startsWith(string2)) {
            return string;
        }
        return string2 + " " + string;
    }

    public static String getAPNType(Context context) {
        String string = "";
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        if (connectivityManager == null) {
            return "Unknown";
        }
        if ((connectivityManager = connectivityManager.getActiveNetworkInfo()) == null) {
            return "Unknown";
        }
        int n2 = connectivityManager.getType();
        if (n2 == 1) {
            string = "Wi-Fi";
        } else if (n2 == 0) {
            int n3 = connectivityManager.getSubtype();
            string = (TelephonyManager)context.getSystemService("phone");
            if (string == null) {
                return "Unknown";
            }
            string = n3 >= 13 && n3 <= 19 && !string.isNetworkRoaming() ? "4G" : ((n3 == 3 || n3 == 8 || n3 == 5) && !string.isNetworkRoaming() ? "3G" : ((n3 == 1 || n3 == 2 || n3 == 4) && !string.isNetworkRoaming() ? "2G" : "Unknown"));
        }
        return string;
    }

    public static String getUrlFileName(String string) {
        String string2;
        int n2 = string.lastIndexOf(63);
        if (n2 > 1) {
            String string3 = string;
            string2 = string3.substring(string3.lastIndexOf(47) + 1, n2);
        } else {
            String string4 = string;
            string2 = string4.substring(string4.lastIndexOf(47) + 1);
        }
        return string2;
    }

    public static boolean isTargetUrl(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (string.contains("?")) {
            String string3 = string;
            string = string3.substring(0, string3.indexOf("?"));
        }
        return string.endsWith(string2);
    }

    public static String getUrlWithoutParams(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        if (!string.contains("?")) {
            return string;
        }
        String string2 = string;
        return string2.substring(0, string2.indexOf("?"));
    }

    public static byte[] aesDecrypt(byte[] byArray, byte[] byArray2) {
        Cipher cipher;
        SecretKeySpec secretKeySpec;
        SecretKeySpec secretKeySpec2 = secretKeySpec;
        try {
            secretKeySpec = new SecretKeySpec(byArray, "AES");
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        cipher.init(2, secretKeySpec2);
        return cipher.doFinal(byArray2);
    }

    public static byte[] reverse(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length / 2; ++i2) {
            byte by = byArray[byArray.length - i2 - 1];
            int n2 = byArray.length - i2 - 1;
            byArray[n2] = byArray[i2];
            byArray[i2] = by;
        }
        return byArray;
    }

    public static char[] getChars(byte[] byArray, Charset charset) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return charset.decode(byteBuffer).array();
    }

    @SuppressLint(value={"MissingPermission"})
    public static int getMobileDbm(Context context) {
        int n2 = -1;
        Object object = ((TelephonyManager)context.getSystemService("phone")).getAllCellInfo();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                CellInfo cellInfo = (CellInfo)object.next();
                if (cellInfo instanceof CellInfoGsm) {
                    n2 = ((CellInfoGsm)cellInfo).getCellSignalStrength().getDbm();
                    continue;
                }
                if (cellInfo instanceof CellInfoCdma) {
                    n2 = ((CellInfoCdma)cellInfo).getCellSignalStrength().getDbm();
                    continue;
                }
                if (cellInfo instanceof CellInfoWcdma) {
                    n2 = ((CellInfoWcdma)cellInfo).getCellSignalStrength().getDbm();
                    continue;
                }
                if (!(cellInfo instanceof CellInfoLte)) continue;
                n2 = ((CellInfoLte)cellInfo).getCellSignalStrength().getDbm();
            }
        }
        return n2;
    }

    public static String getDefinitionInString(Context stringArray, VideoDefinition videoDefinition) {
        stringArray = stringArray.getResources().getStringArray(R.array.bjy_player_definition);
        switch (a.a[videoDefinition.ordinal()]) {
            default: {
                return stringArray[2];
            }
            case 6: {
                return stringArray[5];
            }
            case 5: {
                return stringArray[4];
            }
            case 4: {
                return stringArray[3];
            }
            case 3: {
                return stringArray[2];
            }
            case 2: {
                return stringArray[1];
            }
            case 1: 
        }
        return stringArray[0];
    }
}

