/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class BASE64 {
    private BASE64() {
    }

    public static Encoder getEncoder() {
        return Encoder.RFC4648;
    }

    public static Encoder getUrlEncoder() {
        return Encoder.RFC4648_URLSAFE;
    }

    public static Encoder getMimeEncoder() {
        return Encoder.RFC2045;
    }

    public static Encoder getMimeEncoder(int n2, byte[] byArray) {
        Objects.requireNonNull(byArray);
        int[] nArray = Decoder.fromBASE64;
        int n3 = byArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = byArray[i2];
            if (nArray[by & 0xFF] == -1) {
                continue;
            }
            throw new IllegalArgumentException("Illegal base64 line separator character 0x" + Integer.toString(by, 16));
        }
        if (n2 <= 0) {
            return Encoder.RFC4648;
        }
        n2 = n2 >> 2 << 2;
        return new Encoder(false, byArray, n2, true, null);
    }

    public static Decoder getDecoder() {
        return Decoder.RFC4648;
    }

    public static Decoder getUrlDecoder() {
        return Decoder.RFC4648_URLSAFE;
    }

    public static Decoder getMimeDecoder() {
        return Decoder.RFC2045;
    }

    public static class Encoder {
        private static final char[] toBASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        private static final char[] toBASE64URL = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        private static final int MIMELINEMAX = 76;
        private static final byte[] CRLF;
        public static final Encoder RFC4648;
        public static final Encoder RFC4648_URLSAFE;
        public static final Encoder RFC2045;
        private final byte[] newline;
        private final int linemax;
        private final boolean isURL;
        private final boolean doPadding;

        private Encoder(boolean bl, byte[] byArray, int n2, boolean bl2) {
            this.isURL = bl;
            this.newline = byArray;
            this.linemax = n2;
            this.doPadding = bl2;
        }

        private final int outLength(int n2) {
            int n3;
            if (this.doPadding) {
                n2 = (n2 + 2) / 3 * 4;
            } else {
                n3 = n2 % 3;
                n2 = n2 / 3 * 4;
                n3 = n3 == 0 ? 0 : ++n3;
                n2 += n3;
            }
            n3 = this.linemax;
            if (n3 > 0) {
                int n4 = n2;
                n2 = n4 + (n4 - 1) / n3 * this.newline.length;
            }
            return n2;
        }

        private int encode0(byte[] byArray, int n2, int n3, byte[] byArray2) {
            char[] cArray = this.isURL ? toBASE64URL : toBASE64;
            int n4 = (n3 - n2) / 3 * 3;
            int n5 = n2 + n4;
            int n6 = this.linemax;
            if (n6 > 0 && n4 > n6 / 4 * 3) {
                n4 = n6 / 4 * 3;
            }
            n6 = 0;
            while (n2 < n5) {
                int n7;
                int n8 = Math.min(n2 + n4, n5);
                int n9 = n6;
                int n10 = n2;
                while (n10 < n8) {
                    int n11 = (byArray[n10++] & 0xFF) << 16 | (byArray[n10++] & 0xFF) << 8 | byArray[n10++] & 0xFF;
                    int n12 = n7 = n11;
                    int n13 = n7;
                    byArray2[n9++] = (byte)cArray[n7 >>> 18 & 0x3F];
                    n7 = n9 + 1;
                    byArray2[n9] = (byte)cArray[n13 >>> 12 & 0x3F];
                    n9 = n7 + 1;
                    byArray2[n7] = (byte)cArray[n12 >>> 6 & 0x3F];
                    n7 = n9 + 1;
                    byArray2[n9] = (byte)cArray[n11 & 0x3F];
                    n9 = n7;
                }
                int n14 = (n8 - n2) / 3 * 4;
                n2 = n14;
                n2 = n6 + n2;
                if (n14 == this.linemax && n8 < n3) {
                    byte[] byArray3 = this.newline;
                    n10 = this.newline.length;
                    for (n9 = 0; n9 < n10; ++n9) {
                        n7 = n2 + 1;
                        byArray2[n2] = byArray3[n9];
                        n2 = n7;
                    }
                }
                n6 = n2;
                n2 = n8;
            }
            if (n2 < n3) {
                n4 = n2 + 1;
                int n15 = n3;
                n2 = byArray[n2] & 0xFF;
                n3 = n6 + 1;
                byArray2[n6] = (byte)cArray[n2 >> 2];
                if (n4 == n15) {
                    n6 = n3 + 1;
                    byArray2[n3] = (byte)cArray[n2 << 4 & 0x3F];
                    if (this.doPadding) {
                        int n16 = n6 + 1;
                        byArray2[n6] = 61;
                        n6 = n16 + 1;
                        byArray2[n16] = 61;
                    }
                } else {
                    int n17 = byArray[n4] & 0xFF;
                    int n18 = n3 + 1;
                    byArray2[n3] = (byte)cArray[n2 << 4 & 0x3F | n17 >> 4];
                    n6 = n18 + 1;
                    byArray2[n18] = (byte)cArray[n17 << 2 & 0x3F];
                    if (this.doPadding) {
                        n17 = n6 + 1;
                        byArray2[n6] = 61;
                        n6 = n17;
                    }
                }
            }
            return n6;
        }

        public /* synthetic */ Encoder(boolean bl, byte[] byArray, int n2, boolean bl2, a a2) {
            this(bl, byArray, n2, bl2);
        }

        static {
            byte[] byArray = new byte[2];
            byte[] byArray2 = byArray;
            byArray[0] = 13;
            byArray[1] = 10;
            CRLF = byArray;
            RFC4648 = new Encoder(false, null, -1, true);
            RFC4648_URLSAFE = new Encoder(true, null, -1, true);
            RFC2045 = new Encoder(false, byArray2, 76, true);
        }

        public byte[] encode(byte[] byArray) {
            int n2 = this.outLength(byArray.length);
            int n3 = this.encode0(byArray = new byte[n2], 0, byArray.length, byArray);
            if (n3 != n2) {
                return Arrays.copyOf(byArray, n3);
            }
            return byArray;
        }

        public int encode(byte[] byArray, byte[] byArray2) {
            int n2 = this.outLength(byArray.length);
            if (byArray2.length >= n2) {
                return this.encode0(byArray, 0, byArray.length, byArray2);
            }
            throw new IllegalArgumentException("Output byte array is too small for encoding all input bytes");
        }

        public String encodeToString(byte[] byArray) {
            Object object = ((Encoder)object).encode(byArray);
            int n2 = ((Object)object).length;
            return new String((byte[])object, 0, 0, n2);
        }

        public ByteBuffer encode(ByteBuffer object) {
            int n2;
            int n3 = this.outLength(((Buffer)object).remaining());
            byte[] byArray = new byte[n3];
            if (((ByteBuffer)object).hasArray()) {
                ByteBuffer byteBuffer = object;
                ByteBuffer byteBuffer2 = object;
                n2 = byteBuffer2.arrayOffset() + ((Buffer)object).position();
                n2 = this.encode0(((ByteBuffer)object).array(), n2, byteBuffer2.arrayOffset() + ((Buffer)object).limit(), byArray);
                byteBuffer.position(byteBuffer.limit());
            } else {
                ByteBuffer byteBuffer = object;
                n2 = byteBuffer.remaining();
                byte[] byArray2 = new byte[n2];
                object = byArray2;
                byteBuffer.get(byArray2);
                n2 = this.encode0((byte[])object, 0, n2, byArray);
            }
            if (n2 != n3) {
                byArray = Arrays.copyOf(byArray, n2);
            }
            return ByteBuffer.wrap(byArray);
        }

        public OutputStream wrap(OutputStream outputStream) {
            c c2;
            Objects.requireNonNull(outputStream);
            char[] cArray = ((Encoder)object).isURL ? toBASE64URL : toBASE64;
            c c3 = c2;
            Encoder encoder = object;
            Object object = encoder.newline;
            int n2 = encoder.linemax;
            boolean bl = encoder.doPadding;
            c3(outputStream, cArray, (byte[])object, n2, bl);
            return c3;
        }

        public Encoder withoutPadding() {
            if (!this.doPadding) {
                return this;
            }
            Encoder encoder = this;
            boolean bl = encoder.isURL;
            byte[] byArray = encoder.newline;
            int n2 = encoder.linemax;
            return new Encoder(bl, byArray, n2, false);
        }
    }

    public static class Decoder {
        private static final int[] fromBASE64;
        private static final int[] fromBASE64URL;
        public static final Decoder RFC4648;
        public static final Decoder RFC4648_URLSAFE;
        public static final Decoder RFC2045;
        private final boolean isURL;
        private final boolean isMIME;

        private Decoder(boolean bl, boolean bl2) {
            this.isURL = bl;
            this.isMIME = bl2;
        }

        private int outLength(byte[] byArray, int n2, int n3) {
            int n4;
            int[] nArray = this.isURL ? fromBASE64URL : fromBASE64;
            int n5 = 0;
            int n6 = n3 - n2;
            if (n6 == 0) {
                return 0;
            }
            if (n6 < 2) {
                if (this.isMIME && nArray[0] == -1) {
                    return 0;
                }
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
            }
            if (this.isMIME) {
                int n7 = 0;
                while (n2 < n3) {
                    int n8;
                    if ((n8 = byArray[n2++] & 0xFF) == 61) {
                        n6 -= n3 - n2 + 1;
                        break;
                    }
                    if (nArray[n8] != -1) continue;
                    ++n7;
                }
                n6 -= n7;
            } else if (byArray[n3 - 1] == 61) {
                n5 = 1;
                if (byArray[n3 - 2] == 61) {
                    n5 = 2;
                }
            }
            if (n5 == 0 && (n4 = n6 & 3) != 0) {
                n5 = 4 - n4;
            }
            return (n6 + 3) / 4 * 3 - n5;
        }

        private int decode0(byte[] byArray, int n2, int n3, byte[] byArray2) {
            block10: {
                int n4;
                int[] nArray;
                block8: {
                    int n5;
                    block9: {
                        int n6;
                        block7: {
                            nArray = this.isURL ? fromBASE64URL : fromBASE64;
                            n4 = 0;
                            n6 = 0;
                            n5 = 18;
                            while (n2 < n3) {
                                int n7;
                                if ((n7 = nArray[byArray[n2++] & 0xFF]) < 0) {
                                    if (n7 == -2) {
                                        if ((n5 != 6 || n2 != n3 && byArray[n2++] == 61) && n5 != 18) break;
                                        throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                                    }
                                    if (this.isMIME) continue;
                                    throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(byArray[n2 - 1], 16));
                                }
                                n6 |= n7 << n5;
                                if ((n5 += -6) >= 0) continue;
                                int n8 = n6;
                                int n9 = n6;
                                byArray2[n4++] = (byte)(n6 >> 16);
                                n6 = n4 + 1;
                                byArray2[n4] = (byte)(n9 >> 8);
                                n4 = n6 + 1;
                                byArray2[n6] = (byte)n8;
                                n6 = 18;
                                int n10 = n5 = 0;
                                n5 = n6;
                                n6 = n10;
                            }
                            if (n5 != 6) break block7;
                            byArray2[n4++] = (byte)(n6 >> 16);
                            break block8;
                        }
                        if (n5 != 0) break block9;
                        int n11 = n4 + 1;
                        byArray2[n4] = (byte)(n6 >> 16);
                        n4 = n11 + 1;
                        byArray2[n11] = (byte)(n6 >> 8);
                        break block8;
                    }
                    if (n5 == 12) break block10;
                }
                while (n2 < n3) {
                    if (this.isMIME && nArray[byArray[n2++]] < 0) continue;
                    throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + n2);
                }
                return n4;
            }
            throw new IllegalArgumentException("Last unit does not have enough valid bits");
        }

        static {
            int n2;
            fromBASE64 = new int[256];
            Arrays.fill(fromBASE64, -1);
            for (n2 = 0; n2 < Encoder.toBASE64.length; ++n2) {
                Decoder.fromBASE64[Encoder.toBASE64[n2]] = n2;
            }
            Decoder.fromBASE64[61] = -2;
            fromBASE64URL = new int[256];
            Arrays.fill(fromBASE64URL, -1);
            for (n2 = 0; n2 < Encoder.toBASE64URL.length; ++n2) {
                Decoder.fromBASE64URL[Encoder.toBASE64URL[n2]] = n2;
            }
            Decoder.fromBASE64URL[61] = -2;
            RFC4648 = new Decoder(false, false);
            RFC4648_URLSAFE = new Decoder(true, false);
            RFC2045 = new Decoder(false, true);
        }

        public byte[] decode(byte[] byArray) {
            int n2 = byArray.length;
            int n3 = byArray.length;
            byte[] byArray2 = new byte[n2 = this.outLength(byArray, 0, n2)];
            int n4 = this.decode0(byArray, 0, n3, byArray2);
            if (n4 != n2) {
                byArray2 = Arrays.copyOf(byArray2, n4);
            }
            return byArray2;
        }

        public byte[] decode(String string) {
            return this.decode(string.getBytes(StandardCharsets.ISO_8859_1));
        }

        public int decode(byte[] byArray, byte[] byArray2) {
            int n2 = this.outLength(byArray, 0, byArray.length);
            if (byArray2.length >= n2) {
                return this.decode0(byArray, 0, byArray.length, byArray2);
            }
            throw new IllegalArgumentException("Output byte array is too small for decoding all input bytes");
        }

        public ByteBuffer decode(ByteBuffer byteBuffer) {
            int n2;
            int n3;
            byte[] byArray;
            block12: {
                block11: {
                    ByteBuffer byteBuffer2 = byteBuffer;
                    int n4 = byteBuffer2.position();
                    try {
                        if (!byteBuffer2.hasArray()) break block11;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        byteBuffer.position(n4);
                        throw illegalArgumentException;
                    }
                    ByteBuffer byteBuffer3 = byteBuffer;
                    ByteBuffer byteBuffer4 = byteBuffer3;
                    ByteBuffer byteBuffer5 = byteBuffer3;
                    ByteBuffer byteBuffer6 = byteBuffer3;
                    ByteBuffer byteBuffer7 = byteBuffer3;
                    byArray = byteBuffer3.array();
                    n3 = byteBuffer5.arrayOffset() + byteBuffer.position();
                    n2 = byteBuffer6.arrayOffset() + byteBuffer.limit();
                    byteBuffer4.position(byteBuffer7.limit());
                    break block12;
                }
                ByteBuffer byteBuffer8 = byteBuffer;
                ByteBuffer byteBuffer9 = byteBuffer8;
                n2 = byteBuffer8.remaining();
                byArray = new byte[n2];
                byteBuffer9.get(byArray);
                n3 = 0;
            }
            byte[] byArray2 = new byte[this.outLength(byArray, n3, n2)];
            int n5 = 0;
            return ByteBuffer.wrap(byArray2, n5, this.decode0(byArray, n3, n2, byArray2));
        }

        public InputStream wrap(InputStream inputStream) {
            b b2;
            Objects.requireNonNull(inputStream);
            int[] nArray = this.isURL ? fromBASE64URL : fromBASE64;
            b b3 = b2;
            boolean bl = this.isMIME;
            b3(inputStream, nArray, bl);
            return b3;
        }
    }

    public static class b
    extends InputStream {
        public final InputStream a;
        public final boolean b;
        public final int[] c;
        public int d = 0;
        public int e = 18;
        public int f = -8;
        public boolean g = false;
        public boolean h = false;
        public byte[] i = new byte[1];

        public b(InputStream inputStream, int[] nArray, boolean bl) {
            this.a = inputStream;
            this.c = nArray;
            this.b = bl;
        }

        @Override
        public int read() throws IOException {
            b b2 = this;
            return b2.read(b2.i, 0, 1) == -1 ? -1 : this.i[0] & 0xFF;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int read(byte[] var1_1, int var2_3, int var3_4) throws IOException {
            block20: {
                block21: {
                    block19: {
                        if (this.h) break block20;
                        if (this.g && this.f < 0) {
                            return -1;
                        }
                        if (var2_3 < 0 || var3_4 < 0 || var3_4 > var1_1.length - var2_3) break block21;
                        if (this.f >= 0) {
                            var4_5 = var2_3;
                            while (true) {
                                if (var3_4 == 0) {
                                    return var4_5 - var2_3;
                                }
                                v0 = this;
                                var5_6 = var4_5 + 1;
                                var6_7 = v0.d;
                                var7_8 = v0.f;
                                var1_1[var4_5] = (byte)(var6_7 >> var7_8);
                                --var3_4;
                                this.f = var7_8 - 8;
                                if (this.f < 0) {
                                    this.d = 0;
                                    break block19;
                                }
                                var4_5 = var5_6;
                            }
                        }
                        var5_6 = var2_3;
                    }
                    while (var3_4 > 0) {
                        block22: {
                            block23: {
                                var4_5 = this.a.read();
                                if (var4_5 == -1) {
                                    this.g = true;
                                    var4_5 = this.e;
                                    if (var4_5 != 18) {
                                        if (var4_5 != 12) {
                                            v1 = var4_5;
                                            v2 = var5_6++;
                                            var4_5 = this.d;
                                            var1_1[v2] = (byte)(var4_5 >> 16);
                                            --var3_4;
                                            if (v1 == 0) {
                                                if (var3_4 == 0) {
                                                    v3 = this;
                                                    v3.d = var4_5 >> 8;
                                                    v3.f = 0;
                                                } else {
                                                    var1_1[var5_6++] = (byte)(var4_5 >> 8);
                                                }
                                            }
                                        } else {
                                            throw new IOException("BASE64 stream has one un-decoded dangling byte.");
                                        }
                                    }
                                    if (var5_6 == var2_3) {
                                        return -1;
                                    }
                                    return var5_6 - var2_3;
                                }
                                if (var4_5 != 61) break block22;
                                var4_5 = this.e;
                                if (var4_5 == 18 || var4_5 == 12 || var4_5 == 6 && this.a.read() != 61) break block23;
                                v4 = var5_6;
                                var4_5 = var5_6 + 1;
                                var5_6 = this.d;
                                var1_1[v4] = (byte)(var5_6 >> 16);
                                --var3_4;
                                if (this.e != 0) ** GOTO lbl65
                                if (var3_4 != 0) {
                                    var1_2 = var4_5 + 1;
                                    var1_1[var4_5] = (byte)(var5_6 >> 8);
                                    var5_6 = var1_2;
                                } else {
                                    v5 = this;
                                    v5.d = var5_6 >> 8;
                                    v5.f = 0;
lbl65:
                                    // 2 sources

                                    var5_6 = var4_5;
                                }
                                this.g = true;
                                break;
                            }
                            throw new IOException("Illegal base64 ending sequence:" + this.e);
                        }
                        if ((var4_5 = this.c[var4_5]) == -1) {
                            if (this.b) continue;
                            throw new IOException("Illegal base64 character " + Integer.toString(var4_5, 16));
                        }
                        v6 = this;
                        var6_7 = v6.d;
                        var7_8 = v6.e;
                        this.d = var6_7 | var4_5 << var7_8;
                        if (var7_8 == 0) {
                            v7 = this;
                            v7.e = 18;
                            v7.f = 16;
                            while ((var4_5 = this.f) >= 0) {
                                var1_1[var5_6++] = (byte)(this.d >> var4_5);
                                this.f = var4_5 -= 8;
                                if ((var3_4 += -1) != 0 || var4_5 < 0) continue;
                                return var5_6 - var2_3;
                            }
                            this.d = 0;
                            continue;
                        }
                        this.e = var7_8 - 6;
                    }
                    return var5_6 - var2_3;
                }
                throw new IndexOutOfBoundsException();
            }
            throw new IOException("Stream is closed");
        }

        @Override
        public int available() throws IOException {
            if (!this.h) {
                return this.a.available();
            }
            throw new IOException("Stream is closed");
        }

        @Override
        public void close() throws IOException {
            if (!this.h) {
                this.h = true;
                this.a.close();
            }
        }
    }

    public static class c
    extends FilterOutputStream {
        public int a = 0;
        public int b;
        public int c;
        public int d;
        public boolean e = false;
        public final char[] f;
        public final byte[] g;
        public final int h;
        public final boolean i;
        public int j = 0;

        public c(OutputStream outputStream, char[] cArray, byte[] byArray, int n2, boolean bl) {
            super(outputStream);
            this.f = cArray;
            this.g = byArray;
            this.h = n2;
            this.i = bl;
        }

        @Override
        public void write(int n2) throws IOException {
            this.write(new byte[]{(byte)(n2 & 0xFF)}, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            if (!this.e) {
                if (n2 >= 0 && n3 >= 0 && n2 + n3 <= byArray.length) {
                    if (n3 == 0) {
                        return;
                    }
                    int n4 = this.a;
                    if (n4 != 0) {
                        if (n4 == 1) {
                            this.c = byArray[n2++] & 0xFF;
                            if ((n3 += -1) == 0) {
                                this.a = n4 + 1;
                                return;
                            }
                        }
                        c c2 = this;
                        c2.d = byArray[n2++] & 0xFF;
                        c2.a();
                        c2.out.write(this.f[this.b >> 2]);
                        c2.out.write(this.f[this.b << 4 & 0x3F | this.c >> 4]);
                        c2.out.write(this.f[this.c << 2 & 0x3F | this.d >> 6]);
                        c2.out.write(this.f[this.d & 0x3F]);
                        c2.j += 4;
                    }
                    int n5 = --n3;
                    n3 = n5 / 3;
                    this.a = n5 - n3 * 3;
                    while (true) {
                        int n6 = n3;
                        n3 = n6 + -1;
                        if (n6 <= 0) break;
                        c c3 = this;
                        this.a();
                        n4 = (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
                        c3.out.write(this.f[n4 >>> 18 & 0x3F]);
                        c3.out.write(this.f[n4 >>> 12 & 0x3F]);
                        c3.out.write(this.f[n4 >>> 6 & 0x3F]);
                        c3.out.write(this.f[n4 & 0x3F]);
                        c3.j += 4;
                    }
                    n3 = this.a;
                    if (n3 == 1) {
                        this.b = byArray[n2] & 0xFF;
                    } else if (n3 == 2) {
                        int n7 = n2;
                        int n8 = n7 + 1;
                        this.b = byArray[n7] & 0xFF;
                        this.c = byArray[n8] & 0xFF;
                    }
                    return;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            throw new IOException("Stream is closed");
        }

        @Override
        public void close() throws IOException {
            if (!this.e) {
                this.e = true;
                int n2 = this.a;
                if (n2 == 1) {
                    c c2 = this;
                    c2.a();
                    c2.out.write(this.f[this.b >> 2]);
                    c2.out.write(this.f[this.b << 4 & 0x3F]);
                    if (c2.i) {
                        c c3 = this;
                        c3.out.write(61);
                        c3.out.write(61);
                    }
                } else if (n2 == 2) {
                    c c4 = this;
                    c4.a();
                    c4.out.write(this.f[this.b >> 2]);
                    c4.out.write(this.f[this.b << 4 & 0x3F | this.c >> 4]);
                    c4.out.write(this.f[this.c << 2 & 0x3F]);
                    if (c4.i) {
                        this.out.write(61);
                    }
                }
                this.a = 0;
                this.out.close();
            }
        }

        public final void a() throws IOException {
            if (this.j == this.h) {
                this.out.write(this.g);
                this.j = 0;
            }
        }
    }
}

