/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.playback.util;

import android.util.Log;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.network.model.LPShortResult;
import com.baijiayun.network.request.LPRequestModel;
import com.baijiayun.videoplayer.bean.CDNInfo;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class PBJsonUtils {
    private static final String TAG = "PBJsonUtils";
    public static Gson gson;
    public static final JsonParser jsonParser;

    public static <T> T parseString(String string, Type type) {
        if (string != null && type != null) {
            try {
                return (T)gson.fromJson(string, type);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                Log.e((String)TAG, (String)("catch exception when format json str:" + string));
                throw jsonSyntaxException;
            }
        }
        return null;
    }

    public static String toString(Object object) {
        return object == null ? "" : gson.toJson(object);
    }

    public static <T> T parseJsonObject(JsonObject jsonObject, Class<T> clazz) {
        return (T)gson.fromJson((JsonElement)jsonObject, clazz);
    }

    public static <T> T parseString(String string, Class<T> clazz) {
        return (T)gson.fromJson(string, clazz);
    }

    public static JsonObject toJsonObject(Object object) {
        return jsonParser.parse(PBJsonUtils.toString(object)).getAsJsonObject();
    }

    public static JsonObject toJsonObject(String string) {
        return jsonParser.parse(string).getAsJsonObject();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getJsonFileAsString(File file) {
        Scanner scanner;
        StringBuilder stringBuilder;
        if (file == null) {
            return "";
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Scanner scanner2 = scanner;
        scanner = new Scanner(file, "utf-8");
        while (true) {
            if (!scanner2.hasNextLine()) break;
            stringBuilder2.append(scanner2.nextLine());
        }
        scanner2.close();
        return stringBuilder2.toString();
        catch (Throwable throwable) {
            try {
                scanner2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
            }
        }
        return stringBuilder2.toString();
    }

    public static <T extends LPRequestModel> Map<String, String> convertRequestJsonToMap(T object) {
        HashMap<String, String> hashMap;
        object = PBJsonUtils.toJsonObject(gson.toJson(object, new TypeToken<T>(){}.getType()));
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>(object.size());
        for (Map.Entry entry : object.entrySet()) {
            String string = (String)entry.getKey();
            Object object2 = (JsonElement)entry.getValue();
            object2 = String.valueOf(object2 instanceof JsonPrimitive ? (((JsonPrimitive)object2).isString() ? object2.getAsString() : object2.toString()) : object2.toString());
            hashMap2.put(string, (String)object2);
        }
        return hashMap2;
    }

    public static boolean isJsonNull(JsonObject jsonObject, String string) {
        if (jsonObject.get(string) != null) {
            return jsonObject.get(string).isJsonNull();
        }
        return false;
    }

    static {
        LPPositionDeserializer lPPositionDeserializer;
        CDNEncUrlDeserializer cDNEncUrlDeserializer;
        LPVideoDefinitionTypeAdapter lPVideoDefinitionTypeAdapter;
        LPDateDeserializer lPDateDeserializer;
        LPLinkTypeDeserializer lPLinkTypeDeserializer;
        LPMediaTypeDeserializer lPMediaTypeDeserializer;
        LPClassTypeDeserializer lPClassTypeDeserializer;
        LPUserTypeDeserializer lPUserTypeDeserializer;
        LPUserStateDeserializer lPUserStateDeserializer;
        LPSpeakStateDeserializer lPSpeakStateDeserializer;
        LPEndTypeDeserializer lPEndTypeDeserializer;
        LPIntegerDeserializer lPIntegerDeserializer;
        LPBooleanDeserializer lPBooleanDeserializer;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Boolean.TYPE, (Object)new LPBooleanDeserializer(null));
        Object object = lPBooleanDeserializer;
        lPBooleanDeserializer = new LPBooleanDeserializer(null);
        gsonBuilder.registerTypeAdapter(Boolean.class, object);
        gsonBuilder.registerTypeAdapter(Integer.TYPE, (Object)new LPIntegerDeserializer(null));
        object = lPIntegerDeserializer;
        lPIntegerDeserializer = new LPIntegerDeserializer(null);
        gsonBuilder.registerTypeAdapter(Integer.class, object);
        object = lPEndTypeDeserializer;
        lPEndTypeDeserializer = new LPEndTypeDeserializer(null);
        gsonBuilder.registerTypeAdapter(LPConstants.LPEndType.class, object);
        object = lPSpeakStateDeserializer;
        lPSpeakStateDeserializer = new LPSpeakStateDeserializer(null);
        gsonBuilder.registerTypeAdapter(LPConstants.LPSpeakState.class, object);
        object = lPUserStateDeserializer;
        lPUserStateDeserializer = new LPUserStateDeserializer(null);
        gsonBuilder.registerTypeAdapter(LPConstants.LPUserState.class, object);
        object = lPUserTypeDeserializer;
        lPUserTypeDeserializer = new LPUserTypeDeserializer(null);
        gsonBuilder.registerTypeAdapter(LPConstants.LPUserType.class, object);
        object = lPClassTypeDeserializer;
        lPClassTypeDeserializer = new LPClassTypeDeserializer(null);
        gsonBuilder.registerTypeAdapter(LPConstants.LPRoomType.class, object);
        object = lPMediaTypeDeserializer;
        lPMediaTypeDeserializer = new LPMediaTypeDeserializer(null);
        gsonBuilder.registerTypeAdapter(LPConstants.LPMediaType.class, object);
        object = lPLinkTypeDeserializer;
        lPLinkTypeDeserializer = new LPLinkTypeDeserializer(null);
        gsonBuilder.registerTypeAdapter(LPConstants.LPLinkType.class, object);
        object = lPDateDeserializer;
        lPDateDeserializer = new LPDateDeserializer(null);
        gsonBuilder.registerTypeAdapter(Date.class, object);
        object = lPVideoDefinitionTypeAdapter;
        lPVideoDefinitionTypeAdapter = new LPVideoDefinitionTypeAdapter();
        gsonBuilder.registerTypeAdapter(LPConstants.VideoDefinition.class, object);
        object = cDNEncUrlDeserializer;
        cDNEncUrlDeserializer = new CDNEncUrlDeserializer(null);
        gsonBuilder.registerTypeAdapter(CDNInfo.class, object);
        object = lPPositionDeserializer;
        lPPositionDeserializer = new LPPositionDeserializer(null);
        gsonBuilder.registerTypeAdapter(LPConstants.LPPosition.class, object);
        gson = gsonBuilder.create();
        jsonParser = new JsonParser();
    }

    public static class LPBooleanDeserializer
    implements JsonDeserializer<Boolean> {
        private LPBooleanDeserializer() {
        }

        public /* synthetic */ LPBooleanDeserializer(a a2) {
            this();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Boolean a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            try {
                LPBooleanDeserializer lPBooleanDeserializer = jsonElement.getAsJsonPrimitive();
            }
            catch (Exception exception) {
                return Boolean.FALSE;
            }
            {
                boolean bl;
                if (lPBooleanDeserializer.isBoolean()) {
                    return lPBooleanDeserializer.getAsBoolean();
                }
                if (lPBooleanDeserializer.getAsInt() != 0) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
        }
    }

    public static class LPIntegerDeserializer
    implements JsonDeserializer<Integer> {
        private LPIntegerDeserializer() {
        }

        public /* synthetic */ LPIntegerDeserializer(a a2) {
            this();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Integer a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            int n2;
            int n3;
            try {
                n3 = jsonElement.getAsInt();
            }
            catch (Exception exception) {
                try {
                    n3 = jsonElement.getAsBoolean() ? 1 : 0;
                }
                catch (Exception exception2) {
                    n2 = 0;
                    exception2.printStackTrace();
                    return n2;
                }
            }
            n2 = n3;
            return n2;
        }
    }

    public static class LPEndTypeDeserializer
    implements JsonDeserializer<LPConstants.LPEndType>,
    JsonSerializer<LPConstants.LPEndType> {
        private LPEndTypeDeserializer() {
        }

        public /* synthetic */ LPEndTypeDeserializer(a a2) {
            this();
        }

        public LPConstants.LPEndType a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return LPConstants.LPEndType.from((int)jsonElement.getAsInt());
        }

        public JsonElement a(LPConstants.LPEndType lPEndType, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)lPEndType.getType());
        }
    }

    public static class LPSpeakStateDeserializer
    implements JsonDeserializer<LPConstants.LPSpeakState>,
    JsonSerializer<LPConstants.LPSpeakState> {
        private LPSpeakStateDeserializer() {
        }

        public /* synthetic */ LPSpeakStateDeserializer(a a2) {
            this();
        }

        public LPConstants.LPSpeakState a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            for (LPConstants.LPSpeakState lPSpeakState : LPConstants.LPSpeakState.values()) {
                if (jsonElement.getAsInt() != lPSpeakState.getType()) continue;
                return lPSpeakState;
            }
            return null;
        }

        public JsonElement a(LPConstants.LPSpeakState lPSpeakState, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)lPSpeakState.getType());
        }
    }

    public static class LPUserStateDeserializer
    implements JsonDeserializer<LPConstants.LPUserState>,
    JsonSerializer<LPConstants.LPUserState> {
        private LPUserStateDeserializer() {
        }

        public /* synthetic */ LPUserStateDeserializer(a a2) {
            this();
        }

        public LPConstants.LPUserState a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            for (LPConstants.LPUserState lPUserState : LPConstants.LPUserState.values()) {
                if (jsonElement.getAsInt() != lPUserState.getType()) continue;
                return lPUserState;
            }
            return null;
        }

        public JsonElement a(LPConstants.LPUserState lPUserState, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)lPUserState.getType());
        }
    }

    public static class LPUserTypeDeserializer
    implements JsonDeserializer<LPConstants.LPUserType>,
    JsonSerializer<LPConstants.LPUserType> {
        private LPUserTypeDeserializer() {
        }

        public /* synthetic */ LPUserTypeDeserializer(a a2) {
            this();
        }

        public LPConstants.LPUserType a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            for (LPConstants.LPUserType lPUserType : LPConstants.LPUserType.values()) {
                if (jsonElement.getAsInt() != lPUserType.getType()) continue;
                return lPUserType;
            }
            return null;
        }

        public JsonElement a(LPConstants.LPUserType lPUserType, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)lPUserType.getType());
        }
    }

    public static class LPClassTypeDeserializer
    implements JsonDeserializer<LPConstants.LPRoomType>,
    JsonSerializer<LPConstants.LPRoomType> {
        private LPClassTypeDeserializer() {
        }

        public /* synthetic */ LPClassTypeDeserializer(a a2) {
            this();
        }

        public LPConstants.LPRoomType a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            for (LPConstants.LPRoomType lPRoomType : LPConstants.LPRoomType.values()) {
                if (jsonElement.getAsInt() != lPRoomType.getType()) continue;
                return lPRoomType;
            }
            return null;
        }

        public JsonElement a(LPConstants.LPRoomType lPRoomType, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)lPRoomType.getType());
        }
    }

    public static class LPMediaTypeDeserializer
    implements JsonDeserializer<LPConstants.LPMediaType>,
    JsonSerializer<LPConstants.LPMediaType> {
        private LPMediaTypeDeserializer() {
        }

        public /* synthetic */ LPMediaTypeDeserializer(a a2) {
            this();
        }

        public LPConstants.LPMediaType a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            for (LPConstants.LPMediaType lPMediaType : LPConstants.LPMediaType.values()) {
                if (jsonElement.getAsInt() != lPMediaType.getType()) continue;
                return lPMediaType;
            }
            return null;
        }

        public JsonElement a(LPConstants.LPMediaType lPMediaType, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)lPMediaType.getType());
        }
    }

    public static class LPLinkTypeDeserializer
    implements JsonDeserializer<LPConstants.LPLinkType>,
    JsonSerializer<LPConstants.LPLinkType> {
        private LPLinkTypeDeserializer() {
        }

        public /* synthetic */ LPLinkTypeDeserializer(a a2) {
            this();
        }

        public LPConstants.LPLinkType a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            for (LPConstants.LPLinkType lPLinkType : LPConstants.LPLinkType.values()) {
                if (jsonElement.getAsInt() != lPLinkType.getType()) continue;
                return lPLinkType;
            }
            return null;
        }

        public JsonElement a(LPConstants.LPLinkType lPLinkType, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)lPLinkType.getType());
        }
    }

    public static class LPDateDeserializer
    implements JsonDeserializer<Date>,
    JsonSerializer<Date> {
        private LPDateDeserializer() {
        }

        public /* synthetic */ LPDateDeserializer(a a2) {
            this();
        }

        public Date a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return new Date(jsonElement.getAsLong() * 1000L);
        }

        public JsonElement a(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)(date.getTime() / 1000L));
        }
    }

    public static class LPVideoDefinitionTypeAdapter
    implements JsonDeserializer<LPConstants.VideoDefinition>,
    JsonSerializer<LPConstants.VideoDefinition> {
        public LPConstants.VideoDefinition deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            for (LPConstants.VideoDefinition videoDefinition : LPConstants.VideoDefinition.values()) {
                if (!videoDefinition.getType().equals(jsonElement.getAsString())) continue;
                return videoDefinition;
            }
            return null;
        }

        public JsonElement serialize(LPConstants.VideoDefinition videoDefinition, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive(videoDefinition.getType());
        }
    }

    public static class CDNEncUrlDeserializer
    implements JsonDeserializer<CDNInfo> {
        public final Gson a;

        private CDNEncUrlDeserializer() {
            Gson gson;
            CDNEncUrlDeserializer cDNEncUrlDeserializer = gson;
            gson = new Gson();
            v1.a = cDNEncUrlDeserializer;
        }

        public /* synthetic */ CDNEncUrlDeserializer(a a2) {
            this();
        }

        public CDNInfo a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if ((jsonElement = jsonElement.getAsJsonObject()).has("enc_url")) {
                if (jsonElement.has("url")) {
                    jsonElement.remove("url");
                }
                JsonElement jsonElement2 = jsonElement;
                jsonElement2.addProperty("url", VideoPlayerUtils.decodeUrl(jsonElement2.get("enc_url").getAsString()));
            }
            return (CDNInfo)this.a.fromJson(jsonElement, type);
        }
    }

    public static class LPPositionDeserializer
    implements JsonDeserializer<LPConstants.LPPosition>,
    JsonSerializer<LPConstants.LPPosition> {
        private LPPositionDeserializer() {
        }

        public /* synthetic */ LPPositionDeserializer(a a2) {
            this();
        }

        public LPConstants.LPPosition a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return LPConstants.LPPosition.from((int)jsonElement.getAsInt());
        }

        public JsonElement a(LPConstants.LPPosition lPPosition, Type type, JsonSerializationContext jsonSerializationContext) {
            return new JsonPrimitive((Number)lPPosition.getPosition());
        }
    }

    public static class LPShortResultDeserializer
    implements JsonDeserializer<LPShortResult> {
        private LPShortResultDeserializer() {
        }

        public LPShortResult a(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            LPShortResult lPShortResult;
            LPShortResultDeserializer lPShortResultDeserializer = jsonElement.getAsJsonObject();
            jsonElement = lPShortResult;
            jsonElement();
            jsonElement.errNo = lPShortResultDeserializer.get("code").getAsInt();
            jsonElement.message = lPShortResultDeserializer.get("msg").getAsString();
            lPShortResult.data = lPShortResultDeserializer.get("data");
            return lPShortResult;
        }
    }
}

