/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.playback.ppt;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.bjyutils.log.LPLogger;
import com.baijiayun.glide.Glide;
import com.baijiayun.glide.load.engine.DiskCacheStrategy;
import com.baijiayun.glide.request.RequestOptions;
import com.baijiayun.glide.request.target.SimpleTarget;
import com.baijiayun.glide.request.target.Target;
import com.baijiayun.glide.request.transition.Transition;
import com.baijiayun.livebase.network.alilog.AliYunLogHelper;
import com.baijiayun.livebase.utils.AliCloudImageUtil;
import com.baijiayun.livebase.utils.LPBJUrl;
import com.baijiayun.livebase.widgets.view.photoview.PhotoView;
import com.baijiayun.playback.PBRoom;
import com.baijiayun.playback.bean.models.LPShapeModel;
import com.baijiayun.playback.ppt.Whiteboard;
import com.baijiayun.playback.ppt.animppt.LPAnimChangeModel;
import com.baijiayun.playback.ppt.animppt.LPDocExtraModel;
import com.baijiayun.playback.ppt.util.LPShapeConverter;
import com.baijiayun.playback.util.PBUtils;
import com.baijiayun.playback.viewmodel.DocListVM;
import com.baijiayun.playback.viewmodel.ShapeVM;
import com.baijiayun.videoplayer.b0;
import com.baijiayun.videoplayer.core.R;
import com.baijiayun.videoplayer.d1;
import com.baijiayun.videoplayer.e1;
import com.baijiayun.videoplayer.p;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class WhiteboardView
extends PhotoView
implements Whiteboard {
    private static final String TAG = WhiteboardView.class.getCanonicalName();
    private static final int DEFAULT_PPT_RECT_SIDE_LENGTH = BJYPlayerSDK.STATIC_PPT_DEFAULT_SIZE;
    private ConcurrentLinkedQueue<d1> shapeList;
    private ConcurrentLinkedQueue<LPShapeModel> shapeModelList;
    private LinkedHashMap<String, p> appendingShapeMap;
    private HashMap<String, ArrayList<p>> appendedShapeMap;
    private ArrayList<LPShapeModel> appendedShapeModelList;
    public int backupPicHostIndex;
    private int mPageIndex;
    private e1 shapeDispatcher;
    private Bitmap loadingImage;
    private boolean isLoading;
    private ShapeVM shapeVM;
    private DocListVM docListVM;
    private String docId;
    private int page;
    private int pageId;
    private List<b0.a> mDocList;
    private List<String> backupPicHost;
    private String defaultPicHost;
    private int currentHeight;
    private int currentWidth;
    private Target<Bitmap> target;
    private PBRoom pbRoom;
    private int retryCount;
    private boolean isSmallCourseBlackboard;

    public WhiteboardView(Context context) {
        this(context, null);
    }

    public WhiteboardView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public WhiteboardView(Context context, AttributeSet attributeSet, int n2) {
        ArrayList arrayList;
        ArrayList arrayList2;
        HashMap hashMap;
        LinkedHashMap linkedHashMap;
        ConcurrentLinkedQueue concurrentLinkedQueue;
        ConcurrentLinkedQueue concurrentLinkedQueue2;
        WhiteboardView whiteboardView = object;
        super(context, attributeSet, n2);
        Object object = concurrentLinkedQueue2;
        concurrentLinkedQueue2 = new ConcurrentLinkedQueue();
        whiteboardView.shapeList = object;
        object = concurrentLinkedQueue;
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        whiteboardView.shapeModelList = object;
        object = linkedHashMap;
        linkedHashMap = new LinkedHashMap();
        whiteboardView.appendingShapeMap = object;
        object = hashMap;
        hashMap = new HashMap();
        whiteboardView.appendedShapeMap = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        whiteboardView.appendedShapeModelList = object;
        whiteboardView.backupPicHostIndex = -1;
        whiteboardView.mPageIndex = -1;
        whiteboardView.isLoading = true;
        object = arrayList;
        arrayList = new ArrayList();
        whiteboardView.mDocList = object;
        whiteboardView.retryCount = 0;
        whiteboardView.initParameters();
    }

    private void initParameters() {
        this.loadingImage = BitmapFactory.decodeResource((Resources)this.getContext().getResources(), (int)R.drawable.pb_bg_ppt_place_holder);
    }

    private void drawAllShapes(Canvas canvas) {
        ConcurrentLinkedQueue<d1> concurrentLinkedQueue = this.shapeList;
        if (concurrentLinkedQueue == null) {
            return;
        }
        for (d1 d12 : concurrentLinkedQueue) {
            if (!d12.c()) continue;
            d12.a(canvas, this.getImageMatrix());
        }
    }

    private void drawAppendingShape(Canvas canvas) {
        LinkedHashMap<String, p> linkedHashMap = this.appendingShapeMap;
        if (linkedHashMap != null && !((AbstractMap)linkedHashMap).isEmpty()) {
            linkedHashMap = this.appendingShapeMap.entrySet().iterator();
            while (linkedHashMap.hasNext()) {
                p p2 = (p)((Map.Entry)linkedHashMap.next()).getValue();
                if (!p2.c()) continue;
                p2.a(canvas, this.getImageMatrix());
            }
            return;
        }
    }

    private void loadCurrentPage(final int n2) {
        if (n2 < this.mDocList.size() && n2 >= 0) {
            String string;
            this.docId = string = this.mDocList.get((int)n2).a;
            if (!"0".equals(string) && this.isSmallCourseBlackboard) {
                return;
            }
            if ("0".equals(this.docId)) {
                int n3 = this.mDocList.get((int)n2).j == -1 ? 0 : this.mDocList.get((int)n2).j;
                WhiteboardView whiteboardView = this;
                whiteboardView.page = n3;
                whiteboardView.pageId = n3;
            } else {
                this.page = this.mDocList.get((int)n2).d;
            }
            if (this.isSmallCourseBlackboard) {
                WhiteboardView whiteboardView = this;
                whiteboardView.onShapeClear();
                whiteboardView.requestPageAllShapes(n2);
                int n4 = whiteboardView.currentWidth;
                whiteboardView.resetDisplayRec(n4, whiteboardView.currentHeight);
                return;
            }
            WhiteboardView whiteboardView = this;
            int n5 = DEFAULT_PPT_RECT_SIDE_LENGTH;
            final String string2 = AliCloudImageUtil.getScaledUrl((String)whiteboardView.getBackgroundUrl(n2), (String)"m_lfit", (int)n5, (int)n5);
            LPLogger.d((String)TAG, (String)("loadUrl position=" + n2 + ",url=" + string2));
            whiteboardView.target = new SimpleTarget<Bitmap>(){

                public void a(@NonNull Bitmap bitmap, @Nullable Transition<? super Bitmap> transition) {
                    a a2 = this;
                    a2.WhiteboardView.this.onShapeClear();
                    a2.WhiteboardView.this.setCurrentWidth(bitmap.getWidth());
                    a2.WhiteboardView.this.setCurrentHeight(bitmap.getHeight());
                    a2.WhiteboardView.this.requestPageAllShapes(n2);
                    Bitmap bitmap2 = bitmap;
                    int n22 = bitmap2.getWidth();
                    a2.WhiteboardView.this.resetDisplayRec(n22, bitmap2.getHeight());
                    a2.WhiteboardView.this.setImageBitmap(bitmap);
                }

                public void onLoadFailed(@Nullable Drawable drawable2) {
                    a a2 = this;
                    super.onLoadFailed(drawable2);
                    if (a2.WhiteboardView.this.retryCount < 3) {
                        a a3 = this;
                        WhiteboardView.this.postDelayed(() -> {
                            LPLogger.d((String)TAG, (String)("onLoadFailed " + a3.string2));
                            if (PBUtils.assertNotDestroyed(WhiteboardView.this.getContext())) {
                                return;
                            }
                            if (WhiteboardView.this.backupPicHost != null && WhiteboardView.this.backupPicHost.size() != 0) {
                                int n22;
                                WhiteboardView whiteboardView = WhiteboardView.this;
                                whiteboardView.backupPicHostIndex = n22 = whiteboardView.backupPicHostIndex + 1;
                                whiteboardView.backupPicHostIndex = n22 % whiteboardView.backupPicHost.size();
                            }
                            a a2 = this;
                            WhiteboardView whiteboardView = a2.WhiteboardView.this;
                            a3.string2 = whiteboardView.generateCDNUrl(a3.string2, whiteboardView.backupPicHostIndex);
                            if (PBUtils.isValidContextForGlide(a2.WhiteboardView.this.getContext())) {
                                Glide.with((Context)WhiteboardView.this.getContext()).asBitmap().load(a3.string2).into(WhiteboardView.this.target);
                            }
                            WhiteboardView.this.retryCount++;
                            AliYunLogHelper.getInstance().addErrorLog("\u9759\u6001\u8bfe\u4ef6\u52a0\u8f7d\u5931\u8d25. \u91cd\u8bd5\u5730\u5740= " + a3.string2 + " \u91cd\u8bd5\u6b21\u6570=" + WhiteboardView.this.retryCount);
                        }, 1000L);
                    }
                }

                public void onLoadCleared(@Nullable Drawable drawable2) {
                    super.onLoadCleared(drawable2);
                    LPLogger.d((String)TAG, (String)("onLoadCleared " + string2));
                }
            };
            if (PBUtils.isValidContextForGlide(whiteboardView.getContext())) {
                WhiteboardView whiteboardView2 = this;
                Glide.with((Context)whiteboardView2.getContext()).asBitmap().load(this.generateCDNUrl(string2, this.backupPicHostIndex)).into(this.target);
                if (!whiteboardView2.pbRoom.isPlaybackOffline()) {
                    this.preload(n2);
                }
            }
            return;
        }
    }

    private void preload(int n2) {
        RequestOptions requestOptions = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.RESOURCE);
        int n3 = n2 + 1;
        if (!TextUtils.isEmpty((CharSequence)((WhiteboardView)((Object)string)).getBackgroundUrl(n3))) {
            WhiteboardView whiteboardView = string;
            int n4 = DEFAULT_PPT_RECT_SIDE_LENGTH;
            String string = AliCloudImageUtil.getScaledUrl((String)whiteboardView.getBackgroundUrl(n3), (String)"m_lfit", (int)n4, (int)n4);
            Glide.with((Context)whiteboardView.getContext()).asBitmap().load(string).apply(requestOptions).preload();
        }
        if (!TextUtils.isEmpty((CharSequence)((WhiteboardView)((Object)string)).getBackgroundUrl(--n2))) {
            WhiteboardView whiteboardView = string;
            int n5 = DEFAULT_PPT_RECT_SIDE_LENGTH;
            String string = AliCloudImageUtil.getScaledUrl((String)whiteboardView.getBackgroundUrl(n2), (String)"m_lfit", (int)n5, (int)n5);
            Glide.with((Context)whiteboardView.getContext()).asBitmap().load(string).apply(requestOptions).preload();
        }
    }

    private String getBackgroundUrl(int n2) {
        if (n2 < this.mDocList.size() && n2 >= 0) {
            if (this.pbRoom.isPlaybackOffline()) {
                WhiteboardView whiteboardView = this;
                return whiteboardView.convertUrlToLocal(whiteboardView.mDocList.get(n2));
            }
            return this.mDocList.get((int)n2).f;
        }
        return "";
    }

    private String generateCDNUrl(String string, int n2) {
        if (n2 == -1) {
            return string;
        }
        LPBJUrl lPBJUrl = this.backupPicHost;
        if (lPBJUrl != null && lPBJUrl.size() != 0) {
            if (n2 >= this.backupPicHost.size()) {
                return string;
            }
            lPBJUrl = LPBJUrl.parse((String)string);
            if (!TextUtils.isEmpty((CharSequence)this.defaultPicHost) && this.defaultPicHost.equals(lPBJUrl.getHost())) {
                return string.replaceFirst(lPBJUrl.getHost(), this.backupPicHost.get(n2));
            }
            return string;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private void handlerShapeAppend(p p4, boolean bl) {
        void var4_8;
        ArrayList arrayList;
        if (p4 == null) {
            return;
        }
        for (d1 object2 : this.shapeList) {
            if (!object2.a.equals(p4.a) || !object2.b.equals(p4.b)) continue;
            return;
        }
        ArrayList<p> arrayList2 = this.appendedShapeMap.get(p4.b);
        if (arrayList2 != null && arrayList2.contains(p4)) {
            return;
        }
        if (arrayList2 == null) {
            ArrayList arrayList3;
            arrayList2 = arrayList3;
            arrayList3 = new ArrayList();
        }
        ArrayList<p> arrayList4 = arrayList2;
        ArrayList<p> arrayList5 = arrayList2;
        arrayList5.add(p4);
        Collections.sort(arrayList5, (p2, p3) -> p2.n - p3.n);
        this.appendedShapeMap.put(p4.b, arrayList2);
        arrayList2 = arrayList;
        arrayList = new ArrayList();
        Iterator iterator = arrayList4.iterator();
        while (iterator.hasNext()) {
            arrayList2.addAll(((p)iterator.next()).d());
        }
        p p5 = this.appendingShapeMap.get(p4.b);
        if (p5 == null) {
            p p6;
            p p7 = p6;
            new p(null, null).a(p4);
        }
        var4_8.a(bl);
        var4_8.a((ArrayList<PointF>)arrayList2);
        ((AbstractMap)this.appendingShapeMap).put(p4.b, (p)var4_8);
    }

    private String convertUrlToLocal(b0.a object) {
        String string;
        object = ((b0.a)object).f;
        if (((String)object).contains("@")) {
            Object object2 = object;
            int n2 = ((String)object2).lastIndexOf("/") + 1;
            string = ((String)object2).substring(n2, ((String)object2).lastIndexOf("@"));
        } else {
            Object object3 = object;
            string = ((String)object3).substring(((String)object3).lastIndexOf("/") + 1);
        }
        if (this.pbRoom.tryLocalPPTFile().containsKey(string)) {
            return "file://" + this.pbRoom.tryLocalPPTFile().get(string);
        }
        return object;
    }

    public void attachPBRoom(PBRoom object) {
        e1 e12;
        if (object == null) {
            return;
        }
        PBRoom pBRoom = object;
        WhiteboardView whiteboardView = this;
        this.pbRoom = object;
        this.backupPicHost = object.getBackupPicHosts();
        this.defaultPicHost = object.getDefaultPicHost();
        object = object.getDocListVM();
        whiteboardView.docListVM = object;
        whiteboardView.mDocList = object.getDocList();
        object = e12;
        whiteboardView.shapeDispatcher = new e1(this);
        this.shapeVM = pBRoom.newShapeVM((ShapeVM.LPShapeReceiverListener)object);
        this.shapeVM.start();
    }

    public void requestPageAllShapes(int n2) {
        if (n2 < this.mDocList.size() && n2 >= 0) {
            if (this.mDocList.get(n2) != null && this.shapeVM != null) {
                if ("0".equals(this.mDocList.get((int)n2).a)) {
                    this.shapeVM.requestPageAllShape(this.mDocList.get((int)n2).a, this.mDocList.get((int)n2).j);
                } else {
                    this.shapeVM.requestPageAllShape(this.mDocList.get((int)n2).a, this.mDocList.get((int)n2).d);
                }
                return;
            }
            return;
        }
    }

    public void requestPageAllShapes(LPAnimChangeModel lPAnimChangeModel) {
        ShapeVM shapeVM = ((WhiteboardView)((Object)string)).shapeVM;
        if (shapeVM == null) {
            return;
        }
        WhiteboardView whiteboardView = string;
        String string = lPAnimChangeModel.docId;
        shapeVM.requestPageAllShape(string, whiteboardView.getPage());
    }

    public void drawLoading(boolean bl) {
        this.isLoading = bl;
        this.invalidate();
    }

    @Override
    public void resetDisplayRec(int n2, int n3) {
        boolean bl = false;
        ConcurrentLinkedQueue<LPShapeModel> concurrentLinkedQueue = this.shapeModelList;
        if (concurrentLinkedQueue != null && !concurrentLinkedQueue.isEmpty()) {
            ArrayList<d1> arrayList;
            ArrayList<d1> arrayList2 = arrayList;
            arrayList = new ArrayList<d1>();
            concurrentLinkedQueue = this.shapeModelList.iterator();
            while (concurrentLinkedQueue.hasNext()) {
                WhiteboardView whiteboardView = this;
                int n4 = whiteboardView.getOffsetWidth();
                int n5 = whiteboardView.getOffsetHeight();
                d1 d12 = LPShapeConverter.getShapeFromModel((LPShapeModel)((Object)concurrentLinkedQueue.next()), n2, n3, n4, n5);
                if (d12 == null) continue;
                arrayList2.add(d12);
            }
            WhiteboardView whiteboardView = this;
            whiteboardView.shapeList.addAll(arrayList2);
            whiteboardView.shapeModelList.clear();
            bl = true;
        }
        if (!this.appendedShapeModelList.isEmpty()) {
            for (LPShapeModel lPShapeModel : this.appendedShapeModelList) {
                WhiteboardView whiteboardView = this;
                int n6 = whiteboardView.getOffsetWidth();
                int n7 = whiteboardView.getOffsetHeight();
                concurrentLinkedQueue = (p)LPShapeConverter.getShapeFromModel(lPShapeModel, n2, n3, n6, n7);
                this.handlerShapeAppend((p)((Object)concurrentLinkedQueue), lPShapeModel.smooth);
            }
            this.appendedShapeModelList.clear();
            bl = true;
        }
        if (bl) {
            this.invalidate();
        }
    }

    public void onDraw(Canvas canvas) {
        WhiteboardView whiteboardView = this;
        super.onDraw(canvas);
        this.drawAllShapes(canvas);
        whiteboardView.drawAppendingShape(canvas);
        if (whiteboardView.isLoading) {
            Canvas canvas2 = canvas;
            float f2 = (canvas2.getWidth() - this.loadingImage.getWidth()) / 2;
            canvas.drawBitmap(this.loadingImage, f2, (float)((canvas2.getHeight() - this.loadingImage.getHeight()) / 2), null);
        }
    }

    @Override
    public void setShapeModels(List<LPShapeModel> list) {
        ConcurrentLinkedQueue<LPShapeModel> concurrentLinkedQueue = ((WhiteboardView)((Object)concurrentLinkedQueue)).shapeModelList;
        if (concurrentLinkedQueue != null) {
            concurrentLinkedQueue.addAll(list);
        }
    }

    @Override
    public void setShapeAppendModels(List<LPShapeModel> list) {
        this.appendedShapeModelList.addAll(list);
    }

    @Override
    public void onShapeClear() {
        WhiteboardView whiteboardView = this;
        whiteboardView.shapeList.clear();
        whiteboardView.appendingShapeMap.clear();
        whiteboardView.appendedShapeMap.clear();
        whiteboardView.isLoading = false;
        whiteboardView.invalidate();
    }

    @Override
    public String getDocId() {
        return this.docId;
    }

    @Override
    public int getPage() {
        if ("0".equals(this.docId)) {
            return this.pageId;
        }
        return this.page;
    }

    public void setCurrentHeight(int n2) {
        this.currentHeight = n2;
        if (this.isSmallCourseBlackboard) {
            WhiteboardView whiteboardView = this;
            whiteboardView.shapeList.clear();
            whiteboardView.loadCurrentPage(whiteboardView.mPageIndex);
        }
    }

    public void setCurrentWidth(int n2) {
        this.currentWidth = n2;
    }

    @Override
    public int getCurrentWidth() {
        return this.currentWidth;
    }

    @Override
    public int getCurrentHeight() {
        return this.currentHeight;
    }

    @Override
    public int getOffsetWidth() {
        return 0;
    }

    @Override
    public int getOffsetHeight() {
        return 0;
    }

    public void setDocList(List<b0.a> list) {
        this.mDocList = list;
    }

    @Override
    public void onShapeAdd(List<d1> object) {
        object = object.iterator();
        while (object.hasNext()) {
            d1 d12 = (d1)object.next();
            if (this.shapeList.contains(d12)) continue;
            WhiteboardView whiteboardView = this;
            whiteboardView.shapeList.add(d12);
            whiteboardView.appendedShapeMap.remove(d12.b);
            ((AbstractMap)whiteboardView.appendingShapeMap).remove(d12.b);
        }
        this.invalidate();
    }

    @Override
    public void onShapeAppend(List<d1> object) {
        object = object.iterator();
        while (object.hasNext()) {
            p p2 = (p)((d1)object.next());
            this.handlerShapeAppend(p2, p2.o);
        }
        this.invalidate();
    }

    @Override
    public void onShapeUpdate(List<d1> object) {
        object = object.iterator();
        while (object.hasNext()) {
            d1 d12 = (d1)object.next();
            d1 d13 = null;
            for (d1 d14 : this.shapeList) {
                if (!d12.b.equals(d14.b) && !d12.a.equals(d14.a)) continue;
                d13 = d14;
                break;
            }
            if (d13 == null) continue;
            WhiteboardView whiteboardView = this;
            whiteboardView.shapeList.remove(d13);
            whiteboardView.shapeList.add(d12);
        }
        this.invalidate();
    }

    @Override
    public void onShapeDelete(List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (TextUtils.isEmpty((CharSequence)string)) continue;
            for (d1 d12 : this.shapeList) {
                if (!string.equals(d12.a)) continue;
                this.shapeList.remove(d12);
                break;
            }
            Object object3 = "";
            Iterator<Map.Entry<String, ArrayList<p>>> iterator = this.appendedShapeMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next().getValue();
                if (object2 == null || object2.isEmpty() || !((p)object2.get((int)0)).a.equals(string)) continue;
                object3 = ((p)object2.get((int)0)).b;
                break;
            }
            if (!TextUtils.isEmpty((CharSequence)object3)) {
                this.appendedShapeMap.remove(object3);
            }
            object3 = "";
            for (Object object2 : this.appendingShapeMap.entrySet()) {
                if (!string.equals(object2.getValue().a)) continue;
                object3 = ((p)object2.getValue()).b;
                break;
            }
            if (TextUtils.isEmpty((CharSequence)object3)) continue;
            ((AbstractMap)this.appendingShapeMap).remove(object3);
        }
        this.invalidate();
    }

    public void updatePage(int n2, boolean bl) {
        if (!(this.mPageIndex != n2 && n2 < this.mDocList.size() || this.isSmallCourseBlackboard)) {
            return;
        }
        AliYunLogHelper.getInstance().addDebugLog("\u9759\u6001\u8bfe\u4ef6\u7ffb\u9875 index=" + n2 + ", \u5168\u90e8\u6587\u6863\u6570\u91cf=" + this.mDocList.size());
        this.shapeList.clear();
        this.loadCurrentPage(n2);
        this.mPageIndex = n2;
    }

    public void setIdentity(LPAnimChangeModel lPAnimChangeModel) {
        this.docId = lPAnimChangeModel.docId;
        this.page = lPAnimChangeModel.page;
    }

    public void setPageId(int n2) {
        this.pageId = n2;
    }

    @Override
    public void destroy() {
        WhiteboardView whiteboardView = this;
        whiteboardView.setImageResource(17170445);
        if (whiteboardView.target != null) {
            Glide.with((Context)this.getContext().getApplicationContext()).clear(this.target);
        }
        this.docListVM = null;
        ShapeVM shapeVM = this.shapeVM;
        if (shapeVM != null) {
            shapeVM.destroy();
            this.shapeVM = null;
        }
        WhiteboardView whiteboardView2 = this;
        whiteboardView2.shapeList.clear();
        whiteboardView2.shapeModelList.clear();
        whiteboardView2.backupPicHostIndex = -1;
        whiteboardView2.appendedShapeModelList.clear();
        whiteboardView2.appendingShapeMap.clear();
        whiteboardView2.appendedShapeMap.clear();
    }

    @Override
    public void setDoubleTapScaleEnable(boolean bl) {
        this.getAttacher().setDoubleTapScaleEnable(bl);
    }

    @Override
    public void syncZoomAndScroll(LPDocExtraModel lPDocExtraModel) {
        if (lPDocExtraModel == null) {
            return;
        }
        if (TextUtils.equals((CharSequence)this.docId, (CharSequence)lPDocExtraModel.docId)) {
            float f2 = LPDocExtraModel.getFloatValue(lPDocExtraModel.scale, 1.0f);
            if (Float.valueOf(1.0f).equals(Float.valueOf(f2))) {
                return;
            }
            LPDocExtraModel lPDocExtraModel2 = lPDocExtraModel;
            float f3 = -LPDocExtraModel.getFloatValue(lPDocExtraModel2.scrollLeft, 0.0f);
            float f4 = Math.round(f3 * (float)this.currentWidth);
            f3 = Math.round(-LPDocExtraModel.getFloatValue(lPDocExtraModel2.scrollTop, 0.0f) * (float)this.currentHeight);
            this.setScaleAndTranslate(Math.min(Math.max(f2, 1.0f), 3.0f), 0.0f, 0.0f, f4, f3);
        }
    }

    public void setIsSmallCourseBlackboard(boolean bl) {
        this.isSmallCourseBlackboard = bl;
    }
}

