/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.download;

import android.text.TextUtils;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.baijiayun.download.DownloadListener;
import com.baijiayun.download.DownloadModel;
import com.baijiayun.download.DownloadTask;
import com.baijiayun.download.constant.DownloadType;
import com.baijiayun.download.constant.FileType;
import com.baijiayun.download.constant.TaskStatus;
import com.baijiayun.livebase.utils.FileUtils;
import com.baijiayun.network.HttpException;
import com.baijiayun.videoplayer.bean.CDNInfo;
import com.baijiayun.videoplayer.r;
import com.baijiayun.videoplayer.s;
import com.baijiayun.videoplayer.t;
import com.baijiayun.videoplayer.util.VideoPlayerUtils;
import java.io.File;
import java.util.concurrent.ExecutorService;

class DownloadTaskImpl
implements DownloadTask,
s,
LifecycleObserver {
    public DownloadListener a;
    public DownloadModel b;
    public r c;
    public t d;
    public ExecutorService e;
    public boolean f;
    public TaskStatus g;

    public DownloadTaskImpl(DownloadModel downloadModel) {
        DownloadTaskImpl downloadTaskImpl = this;
        downloadTaskImpl.b = downloadModel;
        downloadTaskImpl.f = false;
        this.g = downloadModel.status;
    }

    public final boolean f(DownloadModel downloadModel) {
        Object object = downloadModel.fileType;
        return object == FileType.VIDEO || object == FileType.AUDIO;
    }

    public void a(t t2) {
        this.d = t2;
    }

    @Override
    public void start() {
        TaskStatus taskStatus;
        DownloadModel downloadModel = this.b;
        while (downloadModel != null && downloadModel.status == TaskStatus.Finish) {
            downloadModel = downloadModel.nextModel;
        }
        if (downloadModel == null) {
            return;
        }
        Object object = this.a;
        if (object != null) {
            object.onStarted(this);
        }
        if ((object = downloadModel.status) != (taskStatus = TaskStatus.Downloading) && object != TaskStatus.Finish) {
            r r2;
            if (this.f) {
                return;
            }
            DownloadTaskImpl downloadTaskImpl = this;
            downloadTaskImpl.g = taskStatus;
            downloadTaskImpl.f = true;
            downloadModel.status = taskStatus;
            object = r2;
            ((r)((Object)object))(downloadModel, this);
            this.c = object;
            r2.executeOnExecutor(this.e, new Void[0]);
            return;
        }
    }

    @Override
    public void pause() {
        TaskStatus taskStatus;
        Object object;
        if (object2.getTaskStatus() != TaskStatus.Finish) {
            object2.g = TaskStatus.Pause;
        }
        if ((object = object2.a) != null) {
            object.onPaused((DownloadTask)object2);
        }
        object = object2.b;
        while (object != null && (taskStatus = ((DownloadModel)object).status) != TaskStatus.Downloading && taskStatus != TaskStatus.New) {
            object = ((DownloadModel)object).nextModel;
        }
        if (object != null) {
            if (object2.f) {
                return;
            }
            object2.f = true;
            Object object2 = object2.c;
            if (object2 != null) {
                object2.cancel(true);
            }
        }
    }

    @Override
    public void cancel() {
        r r2 = this.c;
        if (r2 != null) {
            r2.a(true);
            this.c.cancel(true);
            this.f = false;
        }
    }

    @Override
    public void deleteFiles() {
        Object object = this.b;
        FileUtils.safeDeleteFile((File)new File(((DownloadModel)object).targetFolder, "/subtitle/" + ((DownloadModel)object).videoId));
        FileUtils.safeDeleteFile((File)new File(((DownloadModel)object).targetFolder, "/whiteboard/" + ((DownloadModel)object).videoId));
        while (object != null) {
            TaskStatus taskStatus = ((DownloadModel)object).status;
            if (taskStatus == TaskStatus.Downloading || taskStatus == TaskStatus.New) {
                this.cancel();
            }
            if (!TextUtils.isEmpty((CharSequence)((DownloadModel)object).targetFolder) && !TextUtils.isEmpty((CharSequence)((DownloadModel)object).targetName)) {
                DownloadModel downloadModel = object;
                Object object2 = object;
                object = ((DownloadModel)object2).targetFolder;
                FileUtils.safeDeleteFile((File)new File((String)object, ((DownloadModel)object2).targetName));
                object = downloadModel.nextModel;
                continue;
            }
            object = ((DownloadModel)object).nextModel;
        }
        DownloadTaskImpl downloadTaskImpl = this;
        object = downloadTaskImpl.b;
        downloadTaskImpl.b.downloadLength = 0L;
        downloadTaskImpl.b.status = TaskStatus.New;
        downloadTaskImpl.d.e((DownloadModel)object);
        object = downloadTaskImpl.a;
        if (object != null) {
            object.onDeleted(this);
        }
    }

    @Override
    public void setDownloadListener(DownloadListener downloadListener) {
        this.a = downloadListener;
    }

    @Override
    public DownloadModel getVideoDownloadInfo() {
        DownloadModel downloadModel = this.b;
        while (downloadModel != null) {
            if (this.f(downloadModel)) {
                return downloadModel;
            }
            downloadModel = downloadModel.nextModel;
        }
        return this.b;
    }

    @Override
    public DownloadModel getSignalDownloadInfo() {
        Object object = ((DownloadTaskImpl)object).b;
        while (object != null) {
            if (((DownloadModel)object).fileType == FileType.SIGNAL) {
                return object;
            }
            object = ((DownloadModel)object).nextModel;
        }
        return null;
    }

    @Override
    public TaskStatus getTaskStatus() {
        TaskStatus taskStatus = ((DownloadTaskImpl)object).g;
        Object object = ((DownloadTaskImpl)object).b;
        if (taskStatus == ((DownloadModel)object).status) {
            while (object != null) {
                taskStatus = ((DownloadModel)object).status;
                if (taskStatus != TaskStatus.Finish) {
                    return taskStatus;
                }
                object = ((DownloadModel)object).nextModel;
            }
            return TaskStatus.Finish;
        }
        return taskStatus;
    }

    @Override
    public long getSpeed() {
        Object object = ((DownloadTaskImpl)object).b;
        while (object != null) {
            long l2 = ((DownloadModel)object).speed;
            if (l2 != 0L) {
                return l2;
            }
            object = ((DownloadModel)object).nextModel;
        }
        return 0L;
    }

    @Override
    public float getProgress() {
        return (float)this.getDownloadedLength() * 100.0f / (float)this.getTotalLength();
    }

    @Override
    public long getTotalLength() {
        long l2 = 0L;
        Object object = ((DownloadTaskImpl)object).b;
        while (object != null) {
            l2 += ((DownloadModel)object).totalLength;
            object = ((DownloadModel)object).nextModel;
        }
        return l2;
    }

    @Override
    public long getDownloadedLength() {
        long l2 = 0L;
        Object object = ((DownloadTaskImpl)object).b;
        while (object != null) {
            l2 += ((DownloadModel)object).downloadLength;
            object = ((DownloadModel)object).nextModel;
        }
        return l2;
    }

    @Override
    public DownloadType getDownloadType() {
        if (this.b.nextModel == null) {
            return DownloadType.VIDEO;
        }
        return DownloadType.PLAYBACK;
    }

    @Override
    public String getVideoFileName() {
        DownloadModel downloadModel = this.b;
        while (downloadModel != null) {
            if (this.f(downloadModel)) {
                return downloadModel.targetName;
            }
            downloadModel = downloadModel.nextModel;
        }
        return "";
    }

    @Override
    public String getSignalFileName() {
        Object object = ((DownloadTaskImpl)object).b;
        while (object != null) {
            if (((DownloadModel)object).fileType == FileType.SIGNAL) {
                return ((DownloadModel)object).targetName;
            }
            object = ((DownloadModel)object).nextModel;
        }
        return "";
    }

    @Override
    public long getVideoDuration() {
        DownloadModel downloadModel = this.b;
        while (downloadModel != null) {
            if (this.f(downloadModel)) {
                return downloadModel.videoDuration;
            }
            downloadModel = downloadModel.nextModel;
        }
        return 0L;
    }

    @Override
    public String getVideoFilePath() {
        return this.b.targetFolder + this.getVideoFileName();
    }

    @Override
    public String getSignalFilePath() {
        String string = this.getSignalFileName();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return this.b.targetFolder + string;
        }
        throw new NullPointerException("\u70b9\u64ad\u4e0b\u8f7d\u6ca1\u6709\u4fe1\u4ee4\u6587\u4ef6");
    }

    @Override
    public void addLifecycle(LifecycleOwner lifecycleOwner) {
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
    }

    @Override
    public void d(DownloadModel object) {
        object = this.d;
        if (object != null) {
            object.d(this.b);
        }
    }

    @Override
    public void e(DownloadModel downloadModel) {
        t t2 = ((DownloadTaskImpl)t2).d;
        if (t2 != null) {
            t2.e(downloadModel);
        }
    }

    @Override
    public void a(DownloadModel object) {
        object = this.a;
        if (object != null) {
            object.onProgress(this);
        }
        this.f = false;
        if (this.g == TaskStatus.Pause) {
            this.pause();
        } else {
            this.g = TaskStatus.Downloading;
        }
    }

    @Override
    public void a(DownloadModel downloadModel, HttpException httpException) {
        object.f = false;
        if (httpException.getCode() != -1 && httpException.getCode() != 403 && downloadModel.playItem != null && !downloadModel.availableCDN.isEmpty()) {
            downloadModel.url = downloadModel.availableCDN.getFirst();
            object.start();
        } else {
            object.g = TaskStatus.Error;
            DownloadListener downloadListener = object.a;
            if (downloadListener != null) {
                downloadListener.onError((DownloadTask)object, httpException);
            }
            if ((object = downloadModel.fileType) != FileType.SIGNAL && object != FileType.AUDIO) {
                Object object = downloadModel.playItem;
                if (object != null) {
                    object = object.cdnList;
                    int n2 = object.cdnList.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        CDNInfo cDNInfo = object[i2];
                        downloadModel.availableCDN.add(VideoPlayerUtils.decodeUrl(cDNInfo.enc_url));
                    }
                }
            } else {
                downloadModel.availableCDN.add(downloadModel.url);
            }
            if ((object = downloadModel.playItem) != null) {
                downloadModel.url = downloadModel.fileType == FileType.AUDIO ? object.cdnList[0].url : VideoPlayerUtils.decodeUrl(object.cdnList[0].enc_url);
            }
        }
    }

    @Override
    public void c(DownloadModel downloadModel) {
        this.f = false;
        if (this.g == TaskStatus.Downloading) {
            this.start();
        } else {
            this.g = TaskStatus.Pause;
        }
    }

    @Override
    public void b(DownloadModel object) {
        if (((DownloadModel)object).nextModel != null) {
            r r2;
            r r3;
            r r4 = r3 = r2;
            r4(((DownloadModel)object).nextModel, this);
            this.c = r4;
            r2.executeOnExecutor(this.e, new Void[0]);
        } else {
            this.g = TaskStatus.Finish;
            object = this.a;
            if (object != null) {
                object.onFinish(this);
            }
            this.f = false;
        }
    }

    public void a(ExecutorService executorService) {
        this.e = executorService;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void onDestroy() {
        object.a = null;
        Object object = object.c;
        if (object != null) {
            object.cancel(true);
        }
    }
}

