/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.videoplayer.util;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.baijiayun.BJYPlayerSDK;
import com.baijiayun.constant.VideoDefinition;
import com.baijiayun.download.DownloadModel;
import com.baijiayun.livebase.models.LPHorseLamp;
import com.baijiayun.playback.bean.PBEv2FileData;
import com.baijiayun.videoplayer.bean.CDNInfo;
import com.baijiayun.videoplayer.bean.PlayItem;
import com.baijiayun.videoplayer.bean.RuntimeVideoInfo;
import com.baijiayun.videoplayer.bean.SectionItem;
import com.baijiayun.videoplayer.bean.VideoItem;
import io.reactivex.subjects.BehaviorSubject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VideoDataSourceHelper {
    private RuntimeVideoInfo runtimeVideoInfo;
    private VideoItem videoItem;
    private PlayItem playItem;
    private Iterable<VideoDefinition> preferredDefinitions;
    private int mCdnIndex = 0;
    private VideoDefinition selectedDefinition;
    private boolean isOnlineVideo = false;
    private boolean hasAudioUrl = false;
    private PlayItem audioPlayItem;
    private BehaviorSubject<Integer> subjectOfCDNCountChange;
    private List<VideoDefinition> serverDefinitionList = new ArrayList<VideoDefinition>();
    private final Map<String, PBEv2FileData> xorSourceMap = new HashMap<String, PBEv2FileData>();

    public VideoDataSourceHelper() {
        this.runtimeVideoInfo = new RuntimeVideoInfo();
        this.subjectOfCDNCountChange = BehaviorSubject.create();
    }

    private void makeAudioPlayItem(String object) {
        VideoDataSourceHelper videoDataSourceHelper;
        CDNInfo cDNInfo;
        CDNInfo cDNInfo2;
        ((VideoDataSourceHelper)((Object)videoItem)).audioPlayItem = new PlayItem();
        CDNInfo cDNInfo3 = cDNInfo2 = cDNInfo;
        cDNInfo2();
        cDNInfo2.definition = "audio";
        VideoItem videoItem = ((VideoDataSourceHelper)((Object)videoItem)).videoItem;
        cDNInfo3.duration = videoItem.duration;
        cDNInfo3.height = 0;
        cDNInfo3.weight = 0;
        cDNInfo3.width = 0;
        cDNInfo2.url = object;
        cDNInfo.enc_url = object;
        Object object2 = object = videoDataSourceHelper.audioPlayItem;
        ((PlayItem)object2).cdnList = new CDNInfo[]{cDNInfo2};
        ((PlayItem)object2).definition = "audio";
        ((PlayItem)object2).size = 0L;
        videoItem.playInfo.audio = object;
    }

    public void setVideoItem(VideoItem videoItem) {
        this.videoItem = videoItem;
    }

    public void setPreferredDefinitions(Iterable<VideoDefinition> iterable) {
        this.preferredDefinitions = iterable;
    }

    public void makeOnlineVideoItem() {
        this.isOnlineVideo = true;
        this.selectedDefinition = null;
        Object object = this.videoItem;
        if (object == null) {
            return;
        }
        VideoDataSourceHelper videoDataSourceHelper = this;
        videoDataSourceHelper.hasAudioUrl = TextUtils.isEmpty((CharSequence)object.audioUrl) ^ true;
        object = VideoDefinition.from(videoDataSourceHelper.videoItem.vodDefaultDefinition);
        videoDataSourceHelper.serverDefinitionList.clear();
        Iterator<VideoDefinition> iterator = videoDataSourceHelper.videoItem.definition.iterator();
        while (iterator.hasNext()) {
            VideoItem.DefinitionItem object2 = iterator.next();
            this.serverDefinitionList.add(VideoDefinition.from(object2.type));
        }
        if (this.hasAudioUrl) {
            VideoDataSourceHelper videoDataSourceHelper2 = this;
            videoDataSourceHelper2.makeAudioPlayItem(videoDataSourceHelper2.videoItem.audioUrl);
            videoDataSourceHelper2.serverDefinitionList.add(VideoDefinition.Audio);
        }
        if ((iterator = this.preferredDefinitions) != null && iterator.iterator().hasNext()) {
            for (VideoDefinition videoDefinition : this.preferredDefinitions) {
                if (!this.serverDefinitionList.contains((Object)videoDefinition)) continue;
                this.selectedDefinition = videoDefinition;
                break;
            }
            if (this.selectedDefinition == null) {
                this.selectedDefinition = object;
            }
        } else {
            this.selectedDefinition = object;
        }
        VideoDataSourceHelper videoDataSourceHelper3 = this;
        object = videoDataSourceHelper3.videoItem;
        videoDataSourceHelper3.playItem = videoDataSourceHelper3.getPlayInfoByDefinition((VideoItem)object, videoDataSourceHelper3.selectedDefinition);
        videoDataSourceHelper3.runtimeVideoInfo.setVideoId(this.videoItem.videoId);
        videoDataSourceHelper3.runtimeVideoInfo.setDefinition(this.selectedDefinition);
        object = videoDataSourceHelper3.videoItem;
        long l2 = object.mixedDuration;
        if (l2 == 0L) {
            l2 = object.duration;
        }
        VideoDataSourceHelper videoDataSourceHelper4 = this;
        int n2 = (int)l2;
        videoDataSourceHelper4.runtimeVideoInfo.setDuration(n2);
        videoDataSourceHelper4.runtimeVideoInfo.setDefinitions(this.serverDefinitionList);
        videoDataSourceHelper4.runtimeVideoInfo.setVideoTitle(this.videoItem.videoInfo.title);
        videoDataSourceHelper4.runtimeVideoInfo.setSubtitleItemList(this.videoItem.subtitleItems);
    }

    public void setRuntimeVideoId(long l2) {
        this.isOnlineVideo = true;
        this.runtimeVideoInfo.setVideoId(l2);
    }

    public String getVideoUri() {
        if (((VideoDataSourceHelper)((Object)runtimeVideoInfo)).isOnlineVideo) {
            PlayItem playItem = ((VideoDataSourceHelper)((Object)runtimeVideoInfo)).playItem;
            return playItem == null ? null : playItem.cdnList[((VideoDataSourceHelper)((Object)runtimeVideoInfo)).mCdnIndex % playItem.cdnList.length].url;
        }
        RuntimeVideoInfo runtimeVideoInfo = ((VideoDataSourceHelper)((Object)runtimeVideoInfo)).runtimeVideoInfo;
        return runtimeVideoInfo == null ? null : runtimeVideoInfo.getPath();
    }

    public String getVideoCDN() {
        if (this.isOnlineVideo) {
            PlayItem playItem = this.playItem;
            return playItem == null ? null : playItem.cdnList[this.mCdnIndex % playItem.cdnList.length].cdn;
        }
        return null;
    }

    public PlayItem getPlayItem() {
        return this.playItem;
    }

    public void makeLocalVideoItem(DownloadModel downloadModel) {
    }

    public VideoItem makeVideoItem(DownloadModel downloadModel) {
        SectionItem sectionItem;
        VideoItem videoItem;
        VideoDataSourceHelper videoDataSourceHelper = this;
        videoDataSourceHelper.isOnlineVideo = false;
        videoDataSourceHelper.runtimeVideoInfo.setVideoTitle(downloadModel.videoName);
        videoDataSourceHelper.runtimeVideoInfo.setVideoId(downloadModel.videoId);
        videoDataSourceHelper.runtimeVideoInfo.setPath(downloadModel.targetFolder + File.separator + downloadModel.targetName);
        videoDataSourceHelper.runtimeVideoInfo.setDefinition(downloadModel.definition);
        videoDataSourceHelper.runtimeVideoInfo.setDuration((int)downloadModel.videoDuration);
        videoDataSourceHelper.runtimeVideoInfo.setSubtitleItemList(downloadModel.subtitleItems);
        VideoItem videoItem2 = videoItem;
        VideoDataSourceHelper videoDataSourceHelper2 = this;
        videoItem2();
        videoItem2.reportInterval = 120;
        Object object = this = sectionItem;
        ((SectionItem)object)();
        videoItem2.videoInfo = object;
        sectionItem.partnerId = downloadModel.partnerId;
        videoItem2.videoId = downloadModel.videoId;
        videoItem2.duration = downloadModel.videoDuration;
        videoItem2.guid = downloadModel.guid;
        videoItem2.subtitleItems = downloadModel.subtitleItems;
        videoItem2.horseLamp = downloadModel.horseLamp;
        videoItem2.partnerConfig = downloadModel.partnerConfig;
        videoItem2.roomId = downloadModel.roomId;
        videoItem2.sessionId = downloadModel.sessionId;
        videoDataSourceHelper2.videoItem = videoItem2;
        return videoItem;
    }

    public boolean switchCDN() {
        int n2;
        PlayItem playItem = this.playItem;
        if (playItem == null) {
            return false;
        }
        this.mCdnIndex = n2 = this.mCdnIndex + 1;
        return n2 < playItem.cdnList.length;
    }

    public boolean switchCDN(int n2) {
        int n3;
        PlayItem playItem = this.playItem;
        if (playItem == null) {
            return false;
        }
        CDNInfo[] cDNInfoArray = playItem.cdnList;
        this.mCdnIndex = n3 = n2 % playItem.cdnList.length;
        return n3 < cDNInfoArray.length;
    }

    public int getCdnIndex() {
        return this.mCdnIndex;
    }

    public BehaviorSubject<Integer> getObservableOfCDNCountChange() {
        return this.subjectOfCDNCountChange;
    }

    public VideoDefinition getSelectedDefinition() {
        return this.selectedDefinition;
    }

    public boolean hasDefinition(VideoDefinition videoDefinition) {
        return this.serverDefinitionList.contains((Object)videoDefinition);
    }

    public void changeSelectedDefinition(VideoDefinition videoDefinition) {
        VideoDataSourceHelper videoDataSourceHelper = this;
        videoDataSourceHelper.selectedDefinition = videoDefinition;
        videoDataSourceHelper.mCdnIndex = 0;
        videoDataSourceHelper.playItem = videoDataSourceHelper.getPlayInfoByDefinition(videoDataSourceHelper.videoItem, videoDefinition);
        videoDataSourceHelper.runtimeVideoInfo.setDefinition(videoDefinition);
    }

    public RuntimeVideoInfo getRuntimeVideoInfo() {
        return this.runtimeVideoInfo;
    }

    public PlayItem getPlayInfoByDefinition(VideoItem videoItem, VideoDefinition videoDefinition) {
        switch (a.a[videoDefinition.ordinal()]) {
            default: {
                return videoItem.playInfo.high;
            }
            case 5: {
                return videoItem.playInfo.audio;
            }
            case 4: {
                return videoItem.playInfo._1080p;
            }
            case 3: {
                return videoItem.playInfo._720p;
            }
            case 2: {
                return videoItem.playInfo.superHD;
            }
            case 1: 
        }
        return videoItem.playInfo.low;
    }

    public VideoItem.WaterMark getWatermark() {
        VideoItem.WaterMark waterMark;
        Object object = ((VideoDataSourceHelper)object).videoItem;
        if (object == null) {
            return null;
        }
        object = ((VideoItem)object).waterMark;
        if (object != null && (waterMark = BJYPlayerSDK.waterMark) != null) {
            object = waterMark;
        }
        return object;
    }

    public void setXorSourceData(String string, PBEv2FileData pBEv2FileData) {
        this.xorSourceMap.put(string, pBEv2FileData);
    }

    @Nullable
    public PBEv2FileData getXorSourceData(String string) {
        return this.xorSourceMap.get(string);
    }

    public void release() {
        VideoDataSourceHelper videoDataSourceHelper = this;
        videoDataSourceHelper.runtimeVideoInfo = null;
        videoDataSourceHelper.videoItem = null;
        videoDataSourceHelper.playItem = null;
        videoDataSourceHelper.audioPlayItem = null;
    }

    public VideoItem getVideoItem() {
        return this.videoItem;
    }

    public boolean isOnlineVideo() {
        return this.isOnlineVideo;
    }

    public LPHorseLamp getHorseLamp() {
        VideoItem videoItem = ((VideoDataSourceHelper)((Object)videoItem)).videoItem;
        if (videoItem == null) {
            return null;
        }
        return videoItem.horseLamp;
    }

    public boolean canCommentVideo() {
        if (this.videoItem == null) {
            return false;
        }
        return this.isOnlineVideo() && this.videoItem.partnerConfig.enableVideoComment;
    }
}

