/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.playback.bean.models;

import android.text.TextUtils;
import com.baijiayun.livebase.context.LPConstants;
import com.baijiayun.livebase.models.LPDataModel;
import com.baijiayun.livebase.models.LPMessageDataModel;
import com.baijiayun.livebase.models.imodels.IUserModel;
import com.baijiayun.livebase.utils.LPChatMessageParser;
import com.baijiayun.playback.bean.models.LPMessageUserModel;
import com.baijiayun.playback.bean.models.imodels.IMessageModel;
import com.google.gson.annotations.SerializedName;
import java.util.Date;

public class LPMessageModel
extends LPDataModel
implements IMessageModel {
    @SerializedName(value="message_type")
    public String messageType;
    @SerializedName(value="id")
    public String id;
    @Deprecated
    @SerializedName(value="time")
    public Date timestamp;
    @SerializedName(value="offset_timestamp_ms")
    public int offsetTimestamp_ms;
    @SerializedName(value="timestamp")
    public Date newTime;
    @SerializedName(value="content")
    public String content;
    public LPMessageDataModel data;
    @SerializedName(value="from")
    public LPMessageUserModel from;
    @SerializedName(value="to_user")
    public LPMessageUserModel toUser;
    public String to;
    public String fromUserId;
    public String channel;
    public LPConstants.MessageType type;
    public String url;
    public String key;
    public double alpha = 1.0;
    @SerializedName(value="is_virtual")
    public boolean isVirtual;

    public LPMessageModel() {
    }

    public LPMessageModel(String string) {
        this.id = string;
    }

    public LPMessageModel(String string, String string2, String string3, Date date) {
        this.id = string;
        this.content = string2;
        this.fromUserId = string3;
        this.timestamp = date;
    }

    public void parse(LPChatMessageParser object) {
        LPChatMessageParser lPChatMessageParser = object;
        lPChatMessageParser.parseMessage(this.content);
        switch (lPChatMessageParser.getType()) {
            default: {
                this.type = LPConstants.MessageType.Text;
                break;
            }
            case 3: {
                this.type = LPConstants.MessageType.Image;
                this.url = object.getUrl();
                break;
            }
            case 2: {
                this.type = LPConstants.MessageType.EmojiWithName;
                this.key = object.getKey();
                this.url = object.getUrl();
                break;
            }
            case 1: {
                this.type = LPConstants.MessageType.Emoji;
                this.key = object.getKey();
                this.url = object.getUrl();
                break;
            }
            case 0: {
                this.type = LPConstants.MessageType.Text;
            }
        }
        object = this.data;
        if (object != null) {
            if ("emoji".equals(object.type)) {
                this.type = LPConstants.MessageType.Emoji;
            } else if ("image".equals(this.data.type)) {
                this.type = LPConstants.MessageType.Image;
            } else {
                if (!"reward-gift".equals(this.data.type) && !"reward-cash".equals(this.data.type)) {
                    return;
                }
                this.type = LPConstants.MessageType.Reward;
            }
            object = TextUtils.isEmpty((CharSequence)this.url) ? this.data.url : this.url;
            this.url = object;
            this.key = this.data.key;
        }
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public void setContent(String string) {
        this.content = string;
    }

    @Override
    public LPMessageDataModel getData() {
        return this.data;
    }

    public LPMessageUserModel getFrom() {
        return this.from;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    public IUserModel getToUser() {
        return this.toUser;
    }

    public void setFrom(LPMessageUserModel lPMessageUserModel) {
        this.from = lPMessageUserModel;
    }

    public String getFromUserId() {
        return this.fromUserId;
    }

    public void setFromUserId(String string) {
        this.fromUserId = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    public void setId(String string) {
        this.id = string;
    }

    @Override
    public LPConstants.MessageType getMessageType() {
        return this.type;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public int getImageWidth() {
        LPMessageModel lPMessageModel = lPMessageModel.data;
        if (lPMessageModel != null) {
            return ((LPMessageDataModel)lPMessageModel).width;
        }
        return 0;
    }

    @Override
    public int getImageHeight() {
        LPMessageModel lPMessageModel = lPMessageModel.data;
        if (lPMessageModel != null) {
            return ((LPMessageDataModel)lPMessageModel).height;
        }
        return 0;
    }

    public void setMessageType(String string) {
        this.messageType = string;
    }

    @Override
    public Date getTimestamp() {
        return this.newTime;
    }

    @Override
    public Date getTime() {
        return this.timestamp;
    }

    @Override
    public int getOffSetMs() {
        return this.offsetTimestamp_ms;
    }

    @Override
    public boolean isPrivateChat() {
        String string = ((LPMessageModel)((Object)string)).to;
        return string != null && !"-1".equals(string);
    }

    public void setTimestamp(Date date) {
        this.newTime = date;
    }
}

